/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.heat.pump;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.content.heat.pipe.HeatPipeBlock;
import org.antarcticgardens.cna.content.heat.pump.HeatPumpBlockEntity;
import org.jetbrains.annotations.Nullable;

public class HeatPumpBlock
extends Block
implements EntityBlock,
IWrenchable {
    public static BooleanProperty UP = BlockStateProperties.UP;
    public static BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static BooleanProperty EAST = BlockStateProperties.EAST;
    public static BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static BooleanProperty WEST = BlockStateProperties.WEST;
    public static DirectionProperty FACING = BlockStateProperties.FACING;

    public HeatPumpBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, EAST, SOUTH, WEST, FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = this.defaultBlockState();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction dir = context.getClickedFace();
        if (!context.isSecondaryUseActive()) {
            dir = dir.getOpposite();
        }
        state = (BlockState)state.setValue((Property)FACING, (Comparable)dir);
        return HeatPipeBlock.updateState(state, (LevelAccessor)world, pos);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        return HeatPipeBlock.updateState(state, world, pos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        super.neighborChanged(state, level, pos, neighborBlock, neighborPos, movedByPiston);
        level.scheduleTick(pos, (Block)this, 1);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.onPlace(state, level, pos, oldState, movedByPiston);
        level.scheduleTick(pos, (Block)this, 1);
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.box((double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75);
        Direction facing = (Direction)state.getValue((Property)FACING);
        if (((Boolean)state.getValue((Property)UP)).booleanValue() || facing == Direction.UP) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.75, (double)0.25, (double)0.75, (double)1.0, (double)0.75), (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)DOWN)).booleanValue() || facing == Direction.DOWN) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.25, (double)0.75), (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue() || facing == Direction.NORTH) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.0, (double)0.75, (double)0.75, (double)0.25), (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue() || facing == Direction.EAST) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.75, (double)0.25, (double)0.25, (double)1.0, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue() || facing == Direction.SOUTH) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.25, (double)0.25, (double)0.75, (double)0.75, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.OR);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue() || facing == Direction.WEST) {
            shape = Shapes.join((VoxelShape)shape, (VoxelShape)Shapes.box((double)0.0, (double)0.25, (double)0.25, (double)0.25, (double)0.75, (double)0.75), (BooleanOp)BooleanOp.OR);
        }
        return shape;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CNABlockEntityTypes.HEAT_PUMP.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        int on = HeatPipeBlock.massPipe++;
        if (HeatPipeBlock.massPipe >= 20) {
            HeatPipeBlock.massPipe = 0;
        }
        return (world, blockPos, blockState, sel) -> {
            HeatBlockEntity hbe;
            HeatPumpBlockEntity self;
            if ((world.getGameTime() + (long)on) % 20L != 0L || !(sel instanceof HeatPumpBlockEntity) || (self = (HeatPumpBlockEntity)sel).getLevel() == null) {
                return;
            }
            self.lastPump = 0.0f;
            Direction facing = (Direction)state.getValue((Property)FACING);
            BlockEntity entity = world.getBlockEntity(blockPos.relative(facing));
            if (entity instanceof HeatBlockEntity && (hbe = (HeatBlockEntity)entity).canAdd(facing)) {
                float ht = self.heat;
                ht = Math.min(ht, hbe.maxHeat() - hbe.getHeat());
                hbe.addHeat(ht);
                self.lastPump += ht;
                self.heat -= ht;
                if (self.heat > 0.0f) {
                    self.heat = Math.max(0.0f, self.heat - 4.0f);
                }
                self.setChanged();
            }
            HeatBlockEntity.handleOverheat(self);
            HeatBlockEntity.trySync(self);
        };
    }
}

