/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.heat.heater;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.config.CNAConfig;
import org.antarcticgardens.cna.content.heat.HeatBlockEntity;
import org.antarcticgardens.cna.content.heat.heater.HeaterBlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaterBlock
extends Block
implements EntityBlock,
IWrenchable {
    public static final EnumProperty<BlazeBurnerBlock.HeatLevel> STRENGTH = BlazeBurnerBlock.HEAT_LEVEL;

    public HeaterBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(state -> ((BlazeBurnerBlock.HeatLevel)state.getValue(STRENGTH)).ordinal()));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STRENGTH});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return CNABlockEntityTypes.HEATER.create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return (world, blockPos, blockState, sel) -> {
            HeaterBlockEntity self;
            if (world.getGameTime() % 20L != 0L || !(sel instanceof HeaterBlockEntity) || (self = (HeaterBlockEntity)sel).getLevel() == null) {
                return;
            }
            HeatBlockEntity.transferAround(self);
            Double mult = (Double)CNAConfig.getCommon().heaterRequiredHeatMultiplier.get();
            HeatBlockEntity.handleOverheat(self);
            if ((double)self.heat > 500.0 * mult) {
                self.heat -= (float)(500.0 * mult);
                level.setBlock(blockPos, (BlockState)state.setValue(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.SEETHING), 3);
            } else if ((double)self.heat > 400.0 * mult) {
                self.heat -= (float)(400.0 * mult);
                level.setBlock(blockPos, (BlockState)state.setValue(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.KINDLED), 3);
            } else if ((double)self.heat > 100.0 * mult) {
                self.heat -= (float)(100.0 * mult);
                level.setBlock(blockPos, (BlockState)state.setValue(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.FADING), 3);
            } else if ((double)self.heat > 50.0 * mult) {
                self.heat -= (float)(50.0 * mult);
                level.setBlock(blockPos, (BlockState)state.setValue(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.SMOULDERING), 3);
            } else {
                level.setBlock(blockPos, (BlockState)state.setValue(STRENGTH, (Comparable)BlazeBurnerBlock.HeatLevel.NONE), 3);
            }
            self.setChanged();
            HeatBlockEntity.trySync(self);
        };
    }
}

