/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.energising;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.CNABlocks;
import org.antarcticgardens.cna.content.energising.EnergiserBehaviour;
import org.antarcticgardens.cna.content.energising.EnergiserBlock;
import org.antarcticgardens.cna.util.RunnableUtil;
import org.antarcticgardens.cna.util.StringFormatUtil;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.energy.SimpleEnergyStorage;

public class EnergiserBlockEntity
extends KineticBlockEntity {
    private final SimpleEnergyStorage storage;
    public int tier;
    public float size = 0.0f;
    private EnergiserBehaviour energisingBehaviour;
    public long lastCharged = -1L;

    public EnergiserBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tier = state.getBlock().equals(CNABlocks.BASIC_ENERGISER.get()) ? 1 : (state.getBlock().equals(CNABlocks.ADVANCED_ENERGISER.get()) ? 2 : 3);
        this.storage = new SimpleEnergyStorage(EnergiserBlock.getCapacity(this.tier)).onFinalCommit(RunnableUtil.createBlockEntityUpdater((BlockEntity)this));
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (BlockEntityType)((BlockEntityType)CNABlockEntityTypes.ENERGISER.get()));
        this.energisingBehaviour.tier = this.tier;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.putLong("Energy", this.storage.getStoredEnergy());
        super.write(compound, registries, clientPacket);
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.storage.setStoredEnergy(compound.getLong("Energy"));
        super.read(compound, registries, clientPacket);
    }

    protected AABB createRenderBoundingBox() {
        Vec3 pos = new Vec3((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
        return new AABB(pos.subtract(1.0, 3.0, 1.0), pos.add(1.0, 1.0, 1.0));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.energisingBehaviour = new EnergiserBehaviour(this);
        behaviours.add((BlockEntityBehaviour)this.energisingBehaviour);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.energy_stats", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_stored", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.energy_storage", (Object[])new Object[]{StringFormatUtil.formatLong(this.storage.getStoredEnergy()), StringFormatUtil.formatLong(this.storage.getCapacity())}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        if (this.lastCharged != -1L) {
            CreateLang.translate((String)"tooltip.create_new_age.energy_usage", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            CreateLang.translate((String)"tooltip.create_new_age.energy_per_tick", (Object[])new Object[]{StringFormatUtil.formatLong(this.lastCharged)}).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        }
        return super.addToGoggleTooltip(tooltip, isPlayerSneaking);
    }

    public SimpleEnergyStorage getEnergyStorage() {
        return this.storage;
    }

    public float calculateStressApplied() {
        float impact = this.tier == 1 ? 4.0f : (this.tier == 2 ? 8.0f : 32.0f);
        this.lastStressApplied = impact;
        return impact;
    }
}

