/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.electricity.connector;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorBlock;
import org.antarcticgardens.cna.content.electricity.connector.ElectricalConnectorMode;
import org.antarcticgardens.cna.content.electricity.network.ElectricalNetwork;
import org.antarcticgardens.cna.content.electricity.network.NetworkEnergyStorage;
import org.antarcticgardens.cna.content.electricity.wire.WireType;
import org.antarcticgardens.esl.energy.EnergyStorage;

public class ElectricalConnectorBlockEntity
extends BlockEntity
implements IHaveGoggleInformation {
    private final Map<ElectricalConnectorBlockEntity, WireType> connectors = new HashMap<ElectricalConnectorBlockEntity, WireType>();
    private final Map<BlockPos, WireType> connectorPositions = new HashMap<BlockPos, WireType>();
    private ElectricalNetwork network;
    private final NetworkEnergyStorage storage = new NetworkEnergyStorage(this, null);
    private boolean connectionsInitialized = false;
    boolean needsInstanceUpdate = true;

    public ElectricalConnectorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        EnergyStorage.registerForBlockEntity((blockEntity, direction) -> blockEntity.storage, (BlockEntityType)((BlockEntityType)CNABlockEntityTypes.ELECTRICAL_CONNECTOR.get()));
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = new ListTag();
        for (Map.Entry<BlockPos, WireType> e : this.connectorPositions.entrySet()) {
            CompoundTag compound = new CompoundTag();
            compound.put("position", (Tag)NBTHelper.writeVec3i((Vec3i)((Vec3i)e.getKey())));
            compound.put("wire", (Tag)StringTag.valueOf((String)e.getValue().name()));
            list.add((Object)compound);
        }
        tag.put("connections", (Tag)list);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag list = tag.getList("connections", 10);
        this.connectorPositions.clear();
        for (Tag listTag : (Tag[])list.toArray((Object[])new Tag[0])) {
            CompoundTag ct;
            if (!(listTag instanceof CompoundTag) || !(ct = (CompoundTag)listTag).contains("position") || !ct.contains("wire")) continue;
            BlockPos pos = new BlockPos(NBTHelper.readVec3i((ListTag)((ListTag)ct.get("position"))));
            WireType wire = WireType.valueOf(ct.getString("wire"));
            this.connectorPositions.put(pos, wire);
        }
        this.needsInstanceUpdate = true;
        super.loadAdditional(tag, registries);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Map<BlockPos, WireType> getConnectorPositions() {
        return Collections.unmodifiableMap(this.connectorPositions);
    }

    public BlockPos getSupportingBlockPos() {
        return this.getBlockPos().relative(((Direction)this.getBlockState().getValue((Property)BlockStateProperties.FACING)).getOpposite());
    }

    protected void serverTick() {
        if (this.network == null) {
            this.setNetwork(new ElectricalNetwork(this));
        }
        if (!this.connectionsInitialized) {
            this.updateConnections();
            this.connectionsInitialized = true;
        }
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"tooltip.create_new_age.connector_info", (Object[])new Object[0]).style(ChatFormatting.WHITE).forGoggles(tooltip);
        CreateLang.translate((String)"tooltip.create_new_age.mode", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        ElectricalConnectorMode mode = (ElectricalConnectorMode)((Object)this.getBlockState().getValue(ElectricalConnectorBlock.MODE));
        CreateLang.translate((String)("tooltip.create_new_age.connector_mode." + mode.getSerializedName()), (Object[])new Object[0]).style(ChatFormatting.AQUA).forGoggles(tooltip, 1);
        return true;
    }

    protected void neighborChanged() {
        if (this.network != null) {
            this.network.updateConsumersAndSources();
        }
    }

    private void updateConnections() {
        for (Map.Entry<BlockPos, WireType> e : this.connectorPositions.entrySet()) {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(e.getKey());
            if (!(blockEntity instanceof ElectricalConnectorBlockEntity)) continue;
            ElectricalConnectorBlockEntity connector = (ElectricalConnectorBlockEntity)blockEntity;
            this.connect(connector, e.getValue());
        }
        this.needsInstanceUpdate = true;
    }

    protected void remove(Level level) {
        if (!level.isClientSide()) {
            this.network.destroy();
        }
        for (Map.Entry<ElectricalConnectorBlockEntity, WireType> e : this.connectors.entrySet()) {
            e.getKey().disconnect(this);
            e.getKey().updateConnections();
            e.getKey().setChanged();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(e.getKey().getBlockPos());
            Containers.dropContents((Level)level, (BlockPos)this.getBlockPos(), (NonNullList)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{e.getValue().getDroppedItem()}));
        }
    }

    public void connect(ElectricalConnectorBlockEntity entity, WireType wireType) {
        entity.connectWithoutNetworking(this, wireType);
        this.connectWithoutNetworking(entity, wireType);
        entity.setChanged();
        this.setChanged();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.network.addNode(entity);
            serverLevel.getChunkSource().blockChanged(entity.getBlockPos());
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    private void connectWithoutNetworking(ElectricalConnectorBlockEntity entity, WireType wireType) {
        if (!this.connectors.containsKey((Object)entity)) {
            this.connectors.put(entity, wireType);
        }
        if (!this.connectorPositions.containsKey(entity.getBlockPos())) {
            this.connectorPositions.put(entity.getBlockPos(), wireType);
        }
    }

    public void disconnect(ElectricalConnectorBlockEntity entity) {
        this.connectors.remove((Object)entity);
        this.connectorPositions.remove(entity.getBlockPos());
    }

    public boolean isConnected(BlockPos pos) {
        return this.connectorPositions.containsKey(pos);
    }

    public Map<ElectricalConnectorBlockEntity, WireType> getConnectedConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }

    public void setNetwork(ElectricalNetwork network) {
        this.network = network;
        this.storage.setNetwork(network);
    }

    public ElectricalNetwork getNetwork() {
        return this.network;
    }
}

