/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna;

import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.antarcticgardens.cna.CNABlockEntityTypes;
import org.antarcticgardens.cna.CreateNewAge;
import org.antarcticgardens.cna.NeoForgePlatform;
import org.antarcticgardens.cna.content.electricity.network.NetworkTicker;
import org.antarcticgardens.cna.neoforge.content.nuclear.reactor.fuelacceptor.NeoForgeReactorFuelAcceptorBlockEntity;
import org.antarcticgardens.cna.neoforge.data.CreateNewAgeDatagenNeoForge;
import org.antarcticgardens.esl.ESLNeoForge;
import org.antarcticgardens.esl.energy.EnergyStorage;
import org.antarcticgardens.esl.neoforge.energy.E2FEnergyStorageAdapter;

@Mod(value="create_new_age")
public class CreateNewAgeNeoForge
extends CreateNewAge {
    public CreateNewAgeNeoForge(IEventBus eventBus, ModContainer modContainer) {
        this.initialize(new NeoForgePlatform(eventBus));
        NeoForge.EVENT_BUS.addListener(e -> NetworkTicker.tickWorld(e.getLevel()));
        eventBus.addListener(EventPriority.HIGHEST, CreateNewAgeDatagenNeoForge::gatherData);
        eventBus.addListener(NeoForgePlatform::registerDatapack);
        eventBus.addListener(NeoForgeReactorFuelAcceptorBlockEntity::registerCapabilities);
        eventBus.addListener(this::registerCapabilities);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        this.registerBlockEnergyCapability(event, (BlockEntityType)CNABlockEntityTypes.BASIC_MOTOR.get());
        this.registerBlockEnergyCapability(event, (BlockEntityType)CNABlockEntityTypes.ADVANCED_MOTOR.get());
        this.registerBlockEnergyCapability(event, (BlockEntityType)CNABlockEntityTypes.REINFORCED_MOTOR.get());
        this.registerBlockEnergyCapability(event, (BlockEntityType)CNABlockEntityTypes.ELECTRICAL_CONNECTOR.get());
        this.registerBlockEnergyCapability(event, (BlockEntityType)CNABlockEntityTypes.CARBON_BRUSHES.get());
        this.registerBlockEnergyCapability(event, (BlockEntityType)CNABlockEntityTypes.ENERGISER.get());
    }

    private <BE extends BlockEntity> void registerBlockEnergyCapability(RegisterCapabilitiesEvent event, BlockEntityType<BE> blockEntityType) {
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, blockEntityType, (be, context) -> {
            EnergyStorage storage = ESLNeoForge.getInstance().getBlockEnergyStorageManager().find(be.getLevel(), be.getBlockPos(), context);
            return E2FEnergyStorageAdapter.getOrCreate((EnergyStorage)storage);
        });
    }
}

