/*
 * Decompiled with CFR 0.152.
 */
package net.dakotapride.garnished.item.hatchet;

import net.dakotapride.garnished.item.hatchet.HatchetToolItem;
import net.dakotapride.garnished.registry.GarnishedEnchantments;
import net.dakotapride.garnished.registry.GarnishedTags;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Unique;

public class HatchetUtils {
    static ResourceKey<Enchantment> salvaging = GarnishedEnchantments.SALVAGING;
    static ResourceKey<Enchantment> ravaging = GarnishedEnchantments.RAVAGING;
    static ResourceKey<Enchantment> striking = GarnishedEnchantments.STRIKING;
    static ResourceKey<Enchantment> quickStep = GarnishedEnchantments.QUICK_STEP;
    static ResourceKey<Enchantment> leechingCurse = GarnishedEnchantments.LEECHING_CURSE;
    static ResourceKey<Enchantment> rejuvenate = GarnishedEnchantments.REJUVENATE;
    public static final RandomSource random = RandomSource.create();

    public static boolean isAffectedByRavaging(Entity entity) {
        return entity.getType().is(GarnishedTags.IS_AFFECTED_BY_RAVAGING);
    }

    public static boolean isAffectedBySalvaging(Entity entity) {
        return entity.getType().is(GarnishedTags.IS_AFFECTED_BY_SALVAGING);
    }

    public static boolean hasRavaging(LivingEntity entity, ItemStack stack) {
        return HatchetUtils.hasEnchantment(stack, GarnishedTags.RAVAGING);
    }

    public static boolean hasSalvaging(LivingEntity entity, ItemStack stack) {
        return HatchetUtils.hasEnchantment(stack, GarnishedTags.SALVAGING);
    }

    public static boolean hasStriking(LivingEntity entity, ItemStack stack) {
        return HatchetUtils.hasEnchantment(stack, GarnishedTags.STRIKING);
    }

    public static boolean hasLeechingCurse(LivingEntity entity, ItemStack stack) {
        return HatchetUtils.hasEnchantment(stack, GarnishedTags.LEECH_CURSE);
    }

    public static boolean hasRejuvenate(LivingEntity entity, ItemStack stack) {
        return HatchetUtils.hasEnchantment(stack, GarnishedTags.REJUVENATE);
    }

    public static boolean hasQuickStep(LivingEntity entity, ItemStack stack) {
        return HatchetUtils.hasEnchantment(stack, GarnishedTags.QUICK_STEP);
    }

    public static boolean canBeUsedToStripLogs(ItemStack stack) {
        return stack.getItem() instanceof AxeItem || stack.getItem() instanceof HatchetToolItem;
    }

    @Unique
    private static boolean hasEnchantment(ItemStack stack, TagKey<Enchantment> enchantmentTag) {
        return EnchantmentHelper.hasTag((ItemStack)stack, enchantmentTag);
    }
}

