/*
 * Decompiled with CFR 0.152.
 */
package com.axedgaming.endersdelight.items;

import com.axedgaming.endersdelight.blocks.ModBlocks;
import com.axedgaming.endersdelight.items.FoodValues;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"endersdelight");
    public static LinkedHashSet<Supplier<Item>> CREATIVE_TAB_ITEMS = Sets.newLinkedHashSet();
    public static final Supplier<Item> CHORUS_CRATE = ModItems.registerWithTab("chorus_crate", () -> new BlockItem(ModBlocks.CHORUS_CRATE.get(), ModItems.basicItem()));
    public static final Supplier<Item> ENDSTONE_STOVE = ModItems.registerWithTab("endstone_stove", () -> new BlockItem(ModBlocks.ENDSTONE_STOVE.get(), ModItems.basicItem()));
    public static final Supplier<Item> SHULKER_BOWL = ModItems.registerWithTab("shulker_bowl", () -> new Item(ModItems.basicItem().stacksTo(16)));
    public static final Supplier<Item> MITE_CRUST = ModItems.registerWithTab("mite_crust", () -> new Item(ModItems.foodItem(FoodValues.DIET)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            super.appendHoverText(stack, context, tooltip, flag);
            tooltip.add((Component)Component.translatable((String)"tooltip.endersdelight.mite_crust").withStyle(ChatFormatting.GRAY));
        }
    });
    public static final Supplier<Item> ENDER_SHARD = ModItems.registerWithTab("ender_shard", () -> new Item(ModItems.basicItem()));
    public static final Supplier<Item> ENDERMAN_SIGHT = ModItems.registerWithTab("enderman_sight", () -> new Item(ModItems.foodItem(FoodValues.DIET)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            super.appendHoverText(stack, context, tooltip, flag);
            tooltip.add((Component)Component.translatable((String)"tooltip.endersdelight.enderman_sight").withStyle(ChatFormatting.GRAY));
        }
    });
    public static final Supplier<Item> SIGHT_FRAGMENTS = ModItems.registerWithTab("sight_fragments", () -> new Item(ModItems.basicItem()));
    public static final Supplier<Item> SHULKER_MOLLUSK = ModItems.registerWithTab("shulker_mollusk", () -> new Item(ModItems.foodItem(FoodValues.DIET)){

        public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
            super.appendHoverText(stack, context, tooltip, flag);
            tooltip.add((Component)Component.translatable((String)"tooltip.endersdelight.shulker_mollusk").withStyle(ChatFormatting.GRAY));
        }
    });
    public static final Supplier<Item> SHULKER_FILET = ModItems.registerWithTab("shulker_filet", () -> new Item(ModItems.foodItem(FoodValues.DIET)));
    public static final Supplier<Item> UNCANNY_COOKIES = ModItems.registerWithTab("uncanny_cookies", () -> new Item(ModItems.foodItem(FoodValues.UNCANNY_COOKIES)));
    public static final Supplier<Item> CHORUS_JUICE = ModItems.registerWithTab("chorus_juice", () -> new Item(ModItems.drinkItem()));
    public static final Supplier<Item> STRANGE_ECLAIR = ModItems.registerWithTab("strange_eclair", () -> new Item(ModItems.foodItem(FoodValues.STRANGE_ECLAIR)));
    public static final Supplier<Item> CHORUS_PIE = ModItems.registerWithTab("chorus_pie", () -> new BlockItem(ModBlocks.CHORUS_PIE.get(), ModItems.basicItem()));
    public static final Supplier<Item> CHORUS_PIE_SLICE = ModItems.registerWithTab("chorus_pie_slice", () -> new Item(ModItems.foodItem(vectorwing.farmersdelight.common.FoodValues.PIE_SLICE)));
    public static final Supplier<Item> CHORUS_STEW = ModItems.registerWithTab("chorus_stew", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.CHORUS_STEW), true));
    public static final Supplier<Item> CRISPY_SKEWER = ModItems.registerWithTab("crispy_skewer", () -> new Item(ModItems.foodItem(FoodValues.FINGER)));
    public static final Supplier<Item> CRAWLING_SANDWICH = ModItems.registerWithTab("crawling_sandwich", () -> new Item(ModItems.foodItem(FoodValues.CRAWLING_SANDWICH)));
    public static final Supplier<Item> TWISTED_CEREAL = ModItems.registerWithTab("twisted_cereal", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.TWISTED_CEREAL), true));
    public static final Supplier<Item> ENDERMITE_STEW = ModItems.registerWithTab("endermite_stew", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.ENDERMITE_STEW), true));
    public static final Supplier<Item> PEARL_PASTA = ModItems.registerWithTab("pearl_pasta", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.PEARL_PASTA), true));
    public static final Supplier<Item> ENDER_PAELLA = ModItems.registerWithTab("ender_paella", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.ENDER_PAELLA), true, false));
    public static final Supplier<Item> STUFFED_SHULKER_BOWL = ModItems.registerWithTab("stuffed_shulker_bowl", () -> new ConsumableItem(ModItems.bowlFoodItem(FoodValues.STUFFED_SHULKER).stacksTo(16), true));
    public static final Supplier<Item> STUFFED_SHULKER = ModItems.registerWithTab("stuffed_shulker", () -> new BlockItem(ModBlocks.STUFFED_SHULKER_BLOCK.get(), ModItems.basicItem().stacksTo(1)));
    public static final Supplier<Item> ETHEREAL_SAFFRON = ModItems.registerWithTab("ethereal_saffron", () -> new BlockItem(ModBlocks.ETHEREAL_SAFFRON_BUSH.get(), ModItems.basicItem()));
    public static final Supplier<Item> AMBERVEIL = ModItems.registerWithTab("amberveil", () -> new BlockItem(ModBlocks.AMBERVEIL_MUSHROOM.get(), ModItems.basicItem()));
    public static final Supplier<Item> CHORUSFLAME = ModItems.registerWithTab("chorusflame", () -> new BlockItem(ModBlocks.CHORUSFLAME_BUSH.get(), ModItems.basicItem()));
    public static final Supplier<Item> VOIDPEPPER = ModItems.registerWithTab("voidpepper", () -> new BlockItem(ModBlocks.VOIDPEPPER_BUSH.get(), ModItems.basicItem()));
    public static final Supplier<Item> AMBERVEIL_STEW = ModItems.registerWithTab("amberveil_stew", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.AMBERVEIL_STEW), true));
    public static final Supplier<Item> AMBERVEILED_CURRY = ModItems.registerWithTab("amberveiled_curry", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.AMBERVEILED_CURRY), true));
    public static final Supplier<Item> CHICKEN_CURRY = ModItems.registerWithTab("chicken_curry", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.CHICKEN), true));
    public static final Supplier<Item> STEAK_FRIES = ModItems.registerWithTab("steak_fries", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.STEAK_FRIES), false));
    public static final Supplier<Item> VEIL_OF_FLAMES_RISOTTO = ModItems.registerWithTab("veil_of_flames_risotto", () -> new ConsumableItem(ModItems.shulkerBowlFoodItem(FoodValues.RISOTTO), true));

    public static Supplier<Item> registerWithTab(String name, Supplier<Item> supplier) {
        DeferredHolder block = ITEMS.register(name, supplier);
        CREATIVE_TAB_ITEMS.add((Supplier<Item>)block);
        return block;
    }

    public static Item.Properties basicItem() {
        return new Item.Properties();
    }

    public static Item.Properties foodItem(FoodProperties food) {
        return new Item.Properties().food(food);
    }

    public static Item.Properties shulkerBowlFoodItem(FoodProperties food) {
        return new Item.Properties().food(food).craftRemainder(SHULKER_BOWL.get()).stacksTo(16);
    }

    public static Item.Properties bowlFoodItem(FoodProperties food) {
        return new Item.Properties().food(food).craftRemainder(Items.BOWL).stacksTo(16);
    }

    public static Item.Properties drinkItem() {
        return new Item.Properties().craftRemainder(Items.GLASS_BOTTLE).stacksTo(16);
    }
}

