/*
 * Decompiled with CFR 0.152.
 */
package toni.lib.networking.codecs;

import com.mojang.datafixers.util.Function3;
import com.mojang.datafixers.util.Function4;
import com.mojang.datafixers.util.Function5;
import com.mojang.datafixers.util.Function6;
import io.netty.buffer.ByteBuf;
import java.util.function.BiFunction;
import java.util.function.Function;
import toni.lib.networking.codecs.StreamDecoder;
import toni.lib.networking.codecs.StreamEncoder;
import toni.lib.networking.codecs.StreamMemberEncoder;

public interface StreamCodec<B, V>
extends StreamDecoder<B, V>,
StreamEncoder<B, V> {
    public static <B, V> StreamCodec<B, V> of(final StreamEncoder<B, V> streamEncoder, final StreamDecoder<B, V> streamDecoder) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B object) {
                return streamDecoder.decode(object);
            }

            @Override
            public void encode(B object, V object2) {
                streamEncoder.encode(object, object2);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> ofMember(final StreamMemberEncoder<B, V> streamMemberEncoder, final StreamDecoder<B, V> streamDecoder) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B object) {
                return streamDecoder.decode(object);
            }

            @Override
            public void encode(B object, V object2) {
                streamMemberEncoder.encode(object2, object);
            }
        };
    }

    public static <B, V> StreamCodec<B, V> unit(final V object) {
        return new StreamCodec<B, V>(){

            @Override
            public V decode(B objectx) {
                return object;
            }

            @Override
            public void encode(B objectx, V object2) {
                if (!object2.equals(object)) {
                    String var10002 = String.valueOf(object2);
                    throw new IllegalStateException("Can't encode '" + var10002 + "', expected '" + String.valueOf(object) + "'");
                }
            }
        };
    }

    default public <O> StreamCodec<B, O> map(final Function<? super V, ? extends O> function, final Function<? super O, ? extends V> function2) {
        return new StreamCodec<B, O>(){

            @Override
            public O decode(B object) {
                return function.apply(StreamCodec.this.decode(object));
            }

            @Override
            public void encode(B object, O object2) {
                StreamCodec.this.encode(object, function2.apply(object2));
            }
        };
    }

    default public <O extends ByteBuf> StreamCodec<O, V> mapStream(final Function<O, ? extends B> function) {
        return new StreamCodec<O, V>(){

            @Override
            public V decode(O byteBuf) {
                Object object = function.apply(byteBuf);
                return StreamCodec.this.decode(object);
            }

            @Override
            public void encode(O byteBuf, V object) {
                Object object2 = function.apply(byteBuf);
                StreamCodec.this.encode(object2, object);
            }
        };
    }

    default public <U> StreamCodec<B, U> dispatch(final Function<? super U, ? extends V> function, final Function<? super V, ? extends StreamCodec<? super B, ? extends U>> function2) {
        return new StreamCodec<B, U>(){

            @Override
            public U decode(B object) {
                Object object2 = StreamCodec.this.decode(object);
                StreamCodec streamCodec = (StreamCodec)function2.apply(object2);
                return streamCodec.decode(object);
            }

            @Override
            public void encode(B object, U object2) {
                Object object3 = function.apply(object2);
                StreamCodec streamCodec = (StreamCodec)function2.apply(object3);
                StreamCodec.this.encode(object, object3);
                streamCodec.encode(object, object2);
            }
        };
    }

    public static <B, C, T1> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> streamCodec, final Function<C, T1> function, final Function<T1, C> function2) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B object) {
                Object object2 = streamCodec.decode(object);
                return function2.apply(object2);
            }

            @Override
            public void encode(B object, C object2) {
                streamCodec.encode(object, function.apply(object2));
            }
        };
    }

    public static <B, C, T1, T2> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> streamCodec, final Function<C, T1> function, final StreamCodec<? super B, T2> streamCodec2, final Function<C, T2> function2, final BiFunction<T1, T2, C> biFunction) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B object) {
                Object object2 = streamCodec.decode(object);
                Object object3 = streamCodec2.decode(object);
                return biFunction.apply(object2, object3);
            }

            @Override
            public void encode(B object, C object2) {
                streamCodec.encode(object, function.apply(object2));
                streamCodec2.encode(object, function2.apply(object2));
            }
        };
    }

    public static <B, C, T1, T2, T3> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> streamCodec, final Function<C, T1> function, final StreamCodec<? super B, T2> streamCodec2, final Function<C, T2> function2, final StreamCodec<? super B, T3> streamCodec3, final Function<C, T3> function3, final Function3<T1, T2, T3, C> function32) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B object) {
                Object object2 = streamCodec.decode(object);
                Object object3 = streamCodec2.decode(object);
                Object object4 = streamCodec3.decode(object);
                return function32.apply(object2, object3, object4);
            }

            @Override
            public void encode(B object, C object2) {
                streamCodec.encode(object, function.apply(object2));
                streamCodec2.encode(object, function2.apply(object2));
                streamCodec3.encode(object, function3.apply(object2));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> streamCodec, final Function<C, T1> function, final StreamCodec<? super B, T2> streamCodec2, final Function<C, T2> function2, final StreamCodec<? super B, T3> streamCodec3, final Function<C, T3> function3, final StreamCodec<? super B, T4> streamCodec4, final Function<C, T4> function4, final Function4<T1, T2, T3, T4, C> function42) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B object) {
                Object object2 = streamCodec.decode(object);
                Object object3 = streamCodec2.decode(object);
                Object object4 = streamCodec3.decode(object);
                Object object5 = streamCodec4.decode(object);
                return function42.apply(object2, object3, object4, object5);
            }

            @Override
            public void encode(B object, C object2) {
                streamCodec.encode(object, function.apply(object2));
                streamCodec2.encode(object, function2.apply(object2));
                streamCodec3.encode(object, function3.apply(object2));
                streamCodec4.encode(object, function4.apply(object2));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> streamCodec, final Function<C, T1> function, final StreamCodec<? super B, T2> streamCodec2, final Function<C, T2> function2, final StreamCodec<? super B, T3> streamCodec3, final Function<C, T3> function3, final StreamCodec<? super B, T4> streamCodec4, final Function<C, T4> function4, final StreamCodec<? super B, T5> streamCodec5, final Function<C, T5> function5, final Function5<T1, T2, T3, T4, T5, C> function52) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B object) {
                Object object2 = streamCodec.decode(object);
                Object object3 = streamCodec2.decode(object);
                Object object4 = streamCodec3.decode(object);
                Object object5 = streamCodec4.decode(object);
                Object object6 = streamCodec5.decode(object);
                return function52.apply(object2, object3, object4, object5, object6);
            }

            @Override
            public void encode(B object, C object2) {
                streamCodec.encode(object, function.apply(object2));
                streamCodec2.encode(object, function2.apply(object2));
                streamCodec3.encode(object, function3.apply(object2));
                streamCodec4.encode(object, function4.apply(object2));
                streamCodec5.encode(object, function5.apply(object2));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> streamCodec, final Function<C, T1> function, final StreamCodec<? super B, T2> streamCodec2, final Function<C, T2> function2, final StreamCodec<? super B, T3> streamCodec3, final Function<C, T3> function3, final StreamCodec<? super B, T4> streamCodec4, final Function<C, T4> function4, final StreamCodec<? super B, T5> streamCodec5, final Function<C, T5> function5, final StreamCodec<? super B, T6> streamCodec6, final Function<C, T6> function6, final Function6<T1, T2, T3, T4, T5, T6, C> function62) {
        return new StreamCodec<B, C>(){

            @Override
            public C decode(B object) {
                Object object2 = streamCodec.decode(object);
                Object object3 = streamCodec2.decode(object);
                Object object4 = streamCodec3.decode(object);
                Object object5 = streamCodec4.decode(object);
                Object object6 = streamCodec5.decode(object);
                Object object7 = streamCodec6.decode(object);
                return function62.apply(object2, object3, object4, object5, object6, object7);
            }

            @Override
            public void encode(B object, C object2) {
                streamCodec.encode(object, function.apply(object2));
                streamCodec2.encode(object, function2.apply(object2));
                streamCodec3.encode(object, function3.apply(object2));
                streamCodec4.encode(object, function4.apply(object2));
                streamCodec5.encode(object, function5.apply(object2));
                streamCodec6.encode(object, function6.apply(object2));
            }
        };
    }
}

