/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.new_shield_variants;

import com.cursee.monolib.core.MonoLibConfiguration;
import com.cursee.monolib.core.sailing.Sailing;
import forge.com.cursee.new_shield_variants.Constants;
import forge.com.cursee.new_shield_variants.NewShieldVariants;
import forge.com.cursee.new_shield_variants.core.client.ModItemProperties;
import forge.com.cursee.new_shield_variants.core.common.registry.ModItemsForge;
import forge.com.cursee.new_shield_variants.core.common.registry.RegistryForge;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="new_shield_variants")
public class NewShieldVariantsForge {
    public NewShieldVariantsForge() {
        NewShieldVariants.init();
        Sailing.register((String)"New Shield Variants", (String)"new_shield_variants", (String)"2.0.0", (String)"[1.21.1]", Constants.PUBLISHER_AUTHOR, Constants.PRIMARY_CURSEFORGE_MODRINTH);
        NewShieldVariants.debugCommon = MonoLibConfiguration.debugging;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RegistryForge.register(modEventBus);
    }

    public static boolean randomTeleport(LivingEntity livingEntity) {
        Level $$1 = livingEntity.level();
        double $$5 = livingEntity.getX() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
        double $$6 = Mth.clamp((double)(livingEntity.getY() + (double)(livingEntity.getRandom().nextInt(16) - 8)), (double)$$1.getMinBuildHeight(), (double)($$1.getMinBuildHeight() + ((ServerLevel)$$1).getLogicalHeight() - 1));
        double $$7 = livingEntity.getZ() + (livingEntity.getRandom().nextDouble() - 0.5) * 16.0;
        if (livingEntity.isPassenger()) {
            livingEntity.stopRiding();
        }
        Vec3 $$8 = livingEntity.position();
        if (livingEntity.randomTeleport($$5, $$6, $$7, true)) {
            $$1.gameEvent((Holder)GameEvent.TELEPORT, $$8, GameEvent.Context.of((Entity)livingEntity));
            SoundSource $$12 = SoundSource.NEUTRAL;
            SoundEvent $$11 = SoundEvents.CHORUS_FRUIT_TELEPORT;
            $$1.playSound((Player)null, BlockPos.containing((double)livingEntity.getX(), (double)livingEntity.getY(), (double)livingEntity.getZ()), $$11, $$12);
            livingEntity.resetFallDistance();
            return true;
        }
        $$1.gameEvent((Holder)GameEvent.TELEPORT, $$8, GameEvent.Context.of((Entity)livingEntity));
        SoundSource $$12 = SoundSource.NEUTRAL;
        SoundEvent $$11 = SoundEvents.CHORUS_FRUIT_TELEPORT;
        $$1.playSound((Player)null, BlockPos.containing((double)livingEntity.getX(), (double)livingEntity.getY(), (double)livingEntity.getZ()), $$11, $$12);
        livingEntity.resetFallDistance();
        return false;
    }

    @Mod.EventBusSubscriber(modid="new_shield_variants")
    public static class ServerTickHandler {
        @SubscribeEvent
        public static void playerTickEvent(TickEvent.ServerTickEvent event) {
            if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
                for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
                    if (!player.isBlocking()) {
                        return;
                    }
                    if (player.getMainHandItem().is((Item)ModItemsForge.BLAZE_SHIELD.get()) || player.getOffhandItem().is((Item)ModItemsForge.BLAZE_SHIELD.get())) {
                        List nearbyLivingEntities = player.serverLevel().getNearbyEntities(LivingEntity.class, TargetingConditions.forNonCombat(), (LivingEntity)player, player.getBoundingBox().inflate(3.0));
                        if (!nearbyLivingEntities.isEmpty()) {
                            nearbyLivingEntities.forEach(livingEntity -> livingEntity.setRemainingFireTicks(80));
                        }
                        return;
                    }
                    if (player.getMainHandItem().is((Item)ModItemsForge.ENDER_SHIELD.get()) || player.getOffhandItem().is((Item)ModItemsForge.ENDER_SHIELD.get())) {
                        LivingEntity targetForTeleportation;
                        LivingEntity lastAttacker = player.getLastAttacker();
                        List nearbyLivingEntities = player.serverLevel().getNearbyEntities(LivingEntity.class, TargetingConditions.forNonCombat(), (LivingEntity)player, player.getBoundingBox().inflate(3.0));
                        LivingEntity livingEntity2 = targetForTeleportation = lastAttacker == null && !nearbyLivingEntities.isEmpty() ? (LivingEntity)nearbyLivingEntities.get(0) : lastAttacker;
                        if (targetForTeleportation != null && NewShieldVariantsForge.randomTeleport(targetForTeleportation)) {
                            player.stopUsingItem();
                            player.setLastHurtByMob(null);
                        }
                        return;
                    }
                    if (!player.getMainHandItem().is((Item)ModItemsForge.SHULKER_SHIELD.get()) && !player.getOffhandItem().is((Item)ModItemsForge.SHULKER_SHIELD.get())) continue;
                    player.addEffect(new MobEffectInstance(MobEffects.LEVITATION, (int)(player.getRandom().nextDouble() * 40.0)));
                    player.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, (int)(player.getRandom().nextDouble() * 160.0)));
                    return;
                }
            }
        }
    }

    @Mod.EventBusSubscriber(modid="new_shield_variants", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ModItemProperties.addCustomItemProperties());
        }
    }
}

