/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.entity.SmokeEmitterEntity;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

@EventBusSubscriber(modid="rpg_potions")
public class SmokeEventHandler {
    @SubscribeEvent
    public static void onPotionImpact(ProjectileImpactEvent event) {
        Projectile projectile = event.getProjectile();
        if (!(projectile instanceof ThrownPotion)) {
            return;
        }
        ThrownPotion thrownPotion = (ThrownPotion)projectile;
        Level level = event.getProjectile().level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PotionContents potionContents = (PotionContents)thrownPotion.getItem().get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return;
        }
        MobEffectInstance smokeEffect = null;
        ArrayList<MobEffectInstance> remainingEffects = new ArrayList<MobEffectInstance>();
        for (MobEffectInstance effect : potionContents.getAllEffects()) {
            if (effect.getEffect().is(ModEffects.SMOKE.getKey())) {
                smokeEffect = effect;
                continue;
            }
            remainingEffects.add(effect);
        }
        if (smokeEffect == null) {
            return;
        }
        HitResult hitResult = event.getRayTraceResult();
        SmokeEmitterEntity emitter = new SmokeEmitterEntity((Level)serverLevel, hitResult.getLocation().x, hitResult.getLocation().y, hitResult.getLocation().z, smokeEffect.getDuration());
        serverLevel.addFreshEntity((Entity)emitter);
        if (remainingEffects.isEmpty()) {
            event.setCanceled(true);
            thrownPotion.discard();
        } else {
            ItemStack newStack = thrownPotion.getItem().copy();
            PotionContents newContents = new PotionContents(Optional.empty(), Optional.empty(), remainingEffects);
            newStack.set(DataComponents.POTION_CONTENTS, (Object)newContents);
            thrownPotion.setItem(newStack);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(EntityTickEvent.Post event) {
        Level level;
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (entity2.hasEffect(ModEffects.SMOKE) && (level = entity2.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int radius = (Integer)PotionConfig.SMOKE_RADIUS.get();
            int density = (Integer)PotionConfig.SMOKE_PARTICLE_DENSITY.get();
            for (int i = 0; i < density; ++i) {
                double theta = entity2.getRandom().nextDouble() * 2.0 * Math.PI;
                double phi = Math.acos(2.0 * entity2.getRandom().nextDouble() - 1.0);
                double r = Math.cbrt(entity2.getRandom().nextDouble()) * (double)radius;
                double offsetX = r * Math.sin(phi) * Math.cos(theta);
                double offsetY = r * Math.sin(phi) * Math.sin(theta);
                double offsetZ = r * Math.cos(phi);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, entity2.getX() + offsetX, entity2.getY() + offsetY, entity2.getZ() + offsetZ, 1, 0.0, 0.05, 0.0, 0.005);
            }
        }
    }
}

