/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;

@EventBusSubscriber(modid="rpg_potions")
public class ProjectileReboundEventHandler {
    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        Entity shooter;
        LivingEntity livingTarget;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult entityHit = (EntityHitResult)hitResult;
        Projectile projectile = event.getProjectile();
        Entity target = entityHit.getEntity();
        if (target instanceof LivingEntity && (livingTarget = (LivingEntity)target).hasEffect(ModEffects.PROJECTILE_REBOUND) && (shooter = projectile.getOwner()) != null && shooter != target) {
            event.setCanceled(true);
            Vec3 direction = shooter.position().subtract(projectile.position()).normalize();
            projectile.setDeltaMovement(direction.scale(1.5));
            projectile.setOwner(target);
            if (projectile instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)projectile;
                if (!((Boolean)PotionConfig.PROJECTILE_REBOUND_FULL_DAMAGE.get()).booleanValue()) {
                    arrow.setBaseDamage(arrow.getBaseDamage() * 0.75);
                }
            }
        }
    }
}

