/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.event;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.init.ModEffects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="rpg_potions")
public class HeatMarkEventHandler {
    private static final String CASTER_UUID_TAG = "rpg_potions:heat_mark_caster";

    @SubscribeEvent
    public static void onEffectAdded(MobEffectEvent.Added event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance.getEffect() == ModEffects.HEAT_MARK && (entity = event.getEffectSource()) instanceof LivingEntity) {
            LivingEntity caster = (LivingEntity)entity;
            System.out.println("Heat Mark applied to entity: " + String.valueOf(entity2.getUUID()) + " by caster: " + String.valueOf(caster.getUUID()));
            CompoundTag data = entity2.getPersistentData();
            data.putUUID(CASTER_UUID_TAG, caster.getUUID());
        }
    }

    @SubscribeEvent
    public static void onEffectRevmoed(MobEffectEvent.Remove event) {
        LivingEntity entity = event.getEntity();
        if (event.getEffectInstance() != null && event.getEffectInstance().getEffect().is(ModEffects.HEAT_MARK)) {
            entity.setGlowingTag(false);
            entity.getPersistentData().remove(CASTER_UUID_TAG);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        LivingEntity entity = event.getEntity();
        if (event.getEffectInstance().getEffect().is(ModEffects.HEAT_MARK)) {
            entity.setGlowingTag(false);
            entity.getPersistentData().remove(CASTER_UUID_TAG);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        Entity entity;
        CompoundTag data;
        LivingEntity entity2 = event.getEntity();
        if (entity2.hasEffect(ModEffects.HEAT_MARK) && (data = entity2.getPersistentData()).hasUUID(CASTER_UUID_TAG) && (entity = event.getSource().getEntity()) instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)entity;
            UUID casterUUID = data.getUUID(CASTER_UUID_TAG);
            if (attacker.getUUID().equals(casterUUID)) {
                float damage = event.getContainer().getNewDamage();
                event.getContainer().setNewDamage((float)((double)damage * (Double)PotionConfig.HEAT_MARK_DAMAGE_MULTIPLIER.get()));
            }
        }
    }
}

