/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.entity;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import com.leclowndu93150.rpg_potions.init.ModEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class SmokeEmitterEntity
extends Entity {
    private int lifeTicks = 0;
    private int duration;

    public SmokeEmitterEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public SmokeEmitterEntity(Level level, double x, double y, double z, int duration) {
        super((EntityType)ModEntities.SMOKE_EMITTER.get(), level);
        this.setPos(x, y, z);
        this.duration = duration;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int radius = (Integer)PotionConfig.SMOKE_RADIUS.get();
            int density = (Integer)PotionConfig.SMOKE_PARTICLE_DENSITY.get();
            for (int i = 0; i < density; ++i) {
                double theta = this.random.nextDouble() * 2.0 * Math.PI;
                double phi = Math.acos(2.0 * this.random.nextDouble() - 1.0);
                double r = Math.cbrt(this.random.nextDouble()) * (double)radius;
                double offsetX = r * Math.sin(phi) * Math.cos(theta);
                double offsetY = r * Math.sin(phi) * Math.sin(theta);
                double offsetZ = r * Math.cos(phi);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, this.getX() + offsetX, this.getY() + offsetY, this.getZ() + offsetZ, 1, 0.0, 0.05, 0.0, 0.005);
            }
        }
        ++this.lifeTicks;
        if (this.lifeTicks >= this.duration) {
            this.discard();
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.lifeTicks = compound.getInt("LifeTicks");
        this.duration = compound.getInt("Duration");
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("LifeTicks", this.lifeTicks);
        compound.putInt("Duration", this.duration);
    }
}

