/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.entity;

import com.leclowndu93150.rpg_potions.init.ModEntities;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DecoyEntity
extends PathfinderMob {
    private static final EntityDataAccessor<String> PLAYER_NAME = SynchedEntityData.defineId(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> PLAYER_SKIN = SynchedEntityData.defineId(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> PLAYER_UUID = SynchedEntityData.defineId(DecoyEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private int lifeTicks = 0;
    private final NonNullList<ItemStack> armorItems = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> handItems = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> inventoryItems = NonNullList.withSize((int)41, (Object)ItemStack.EMPTY);

    public DecoyEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public DecoyEntity(Level level, Player player) {
        super((EntityType)ModEntities.DECOY.get(), level);
        this.entityData.set(PLAYER_NAME, (Object)player.getName().getString());
        this.entityData.set(PLAYER_SKIN, (Object)player.getGameProfile().getName());
        this.entityData.set(PLAYER_UUID, (Object)player.getUUID().toString());
        this.setCustomName(player.getName());
        this.setCustomNameVisible(false);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item = player.getItemBySlot(slot).copy();
            if (slot.getType() == EquipmentSlot.Type.HAND) {
                this.handItems.set(slot.getIndex(), (Object)item);
                continue;
            }
            if (slot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
            this.armorItems.set(slot.getIndex(), (Object)item);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            this.inventoryItems.set(i, (Object)player.getInventory().getItem(i).copy());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYER_NAME, (Object)"");
        builder.define(PLAYER_SKIN, (Object)"");
        builder.define(PLAYER_UUID, (Object)"");
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return PathfinderMob.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ARMOR, 0.0).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public void tick() {
        super.tick();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("LifeTicks", this.lifeTicks);
        compound.putString("PlayerName", (String)this.entityData.get(PLAYER_NAME));
        compound.putString("PlayerSkin", (String)this.entityData.get(PLAYER_SKIN));
        compound.putString("PlayerUUID", (String)this.entityData.get(PLAYER_UUID));
        ListTag armorList = new ListTag();
        for (Object stack : this.armorItems) {
            if (!stack.isEmpty()) {
                armorList.add((Object)stack.save((HolderLookup.Provider)this.registryAccess()));
                continue;
            }
            armorList.add((Object)new CompoundTag());
        }
        compound.put("ArmorItems", (Tag)armorList);
        ListTag handList = new ListTag();
        for (ItemStack stack : this.handItems) {
            if (!stack.isEmpty()) {
                handList.add((Object)stack.save((HolderLookup.Provider)this.registryAccess()));
                continue;
            }
            handList.add((Object)new CompoundTag());
        }
        compound.put("HandItems", (Tag)handList);
        ListTag inventoryList = new ListTag();
        for (ItemStack stack : this.inventoryItems) {
            if (!stack.isEmpty()) {
                inventoryList.add((Object)stack.save((HolderLookup.Provider)this.registryAccess()));
                continue;
            }
            inventoryList.add((Object)new CompoundTag());
        }
        compound.put("InventoryItems", (Tag)inventoryList);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        int i;
        super.readAdditionalSaveData(compound);
        this.lifeTicks = compound.getInt("LifeTicks");
        this.entityData.set(PLAYER_NAME, (Object)compound.getString("PlayerName"));
        this.entityData.set(PLAYER_SKIN, (Object)compound.getString("PlayerSkin"));
        this.entityData.set(PLAYER_UUID, (Object)compound.getString("PlayerUUID"));
        if (compound.contains("ArmorItems", 9)) {
            ListTag armorList = compound.getList("ArmorItems", 10);
            for (i = 0; i < armorList.size() && i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)armorList.getCompound(i)).orElse(ItemStack.EMPTY));
            }
        }
        if (compound.contains("HandItems", 9)) {
            ListTag handList = compound.getList("HandItems", 10);
            for (i = 0; i < handList.size() && i < this.handItems.size(); ++i) {
                this.handItems.set(i, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)handList.getCompound(i)).orElse(ItemStack.EMPTY));
            }
        }
        if (compound.contains("InventoryItems", 9)) {
            ListTag inventoryList = compound.getList("InventoryItems", 10);
            for (i = 0; i < inventoryList.size() && i < this.inventoryItems.size(); ++i) {
                this.inventoryItems.set(i, (Object)ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)inventoryList.getCompound(i)).orElse(ItemStack.EMPTY));
            }
        }
    }

    public String getPlayerName() {
        return (String)this.entityData.get(PLAYER_NAME);
    }

    public String getPlayerSkin() {
        return (String)this.entityData.get(PLAYER_SKIN);
    }

    public UUID getPlayerUUID() {
        String uuidStr = (String)this.entityData.get(PLAYER_UUID);
        if (uuidStr == null || uuidStr.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(uuidStr);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public ItemStack getItemBySlot(EquipmentSlot slot) {
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            return (ItemStack)this.handItems.get(slot.getIndex());
        }
        if (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            return (ItemStack)this.armorItems.get(slot.getIndex());
        }
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slot, ItemStack stack) {
        if (slot.getType() == EquipmentSlot.Type.HAND) {
            this.handItems.set(slot.getIndex(), (Object)stack);
        } else if (slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR) {
            this.armorItems.set(slot.getIndex(), (Object)stack);
        }
    }

    public NonNullList<ItemStack> getArmorItems() {
        return this.armorItems;
    }

    public NonNullList<ItemStack> getHandItems() {
        return this.handItems;
    }

    public NonNullList<ItemStack> getInventoryItems() {
        return this.inventoryItems;
    }
}

