/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.effect;

import com.leclowndu93150.rpg_potions.config.PotionConfig;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class KnockbackEffect
extends MobEffect {
    public KnockbackEffect() {
        super(MobEffectCategory.HARMFUL, 0xFF4400);
    }

    public boolean isInstantenous() {
        return true;
    }

    public void applyInstantenousEffect(@Nullable Entity source, @Nullable Entity indirectSource, LivingEntity entity, int amplifier, double health) {
        if (!entity.level().isClientSide) {
            double strength = (Double)PotionConfig.KNOCKBACK_STRENGTH.get();
            double verticalMultiplier = (Double)PotionConfig.KNOCKBACK_VERTICAL_MULTIPLIER.get();
            Vec3 lookAngle = entity.getLookAngle().normalize();
            Vec3 knockback = new Vec3(-lookAngle.x * strength, verticalMultiplier * strength, -lookAngle.z * strength);
            entity.setDeltaMovement(entity.getDeltaMovement().add(knockback));
            entity.hurtMarked = true;
        }
    }
}

