/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.rpg_potions.client.renderer;

import com.leclowndu93150.rpg_potions.entity.DecoyEntity;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DecoyRenderer
extends MobRenderer<DecoyEntity, PlayerModel<DecoyEntity>> {
    private final Map<String, ResourceLocation> skinCache = new ConcurrentHashMap<String, ResourceLocation>();

    public DecoyRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
    }

    public ResourceLocation getTextureLocation(DecoyEntity entity) {
        UUID playerUUID = entity.getPlayerUUID();
        String playerName = entity.getPlayerSkin();
        if (playerUUID == null || playerName == null || playerName.isEmpty()) {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
        }
        String cacheKey = playerUUID.toString();
        return this.skinCache.computeIfAbsent(cacheKey, uuid -> {
            try {
                GameProfile profile = new GameProfile(playerUUID, playerName);
                Minecraft mc = Minecraft.getInstance();
                PlayerSkin skin = mc.getSkinManager().getInsecureSkin(profile);
                return skin.texture();
            }
            catch (Exception e) {
                return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/entity/player/wide/steve.png");
            }
        });
    }

    public void render(DecoyEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((LivingEntity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

