/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import noobanidus.mods.lootr.common.api.IOpeners;
import noobanidus.mods.lootr.common.api.annotation.ClientOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface IClientOpeners
extends IOpeners {
    @ClientOnly
    @Nullable
    public Set<UUID> getClientOpeners();

    public boolean isClientOpened();

    public void setClientOpened(boolean var1);

    @Override
    default public boolean clearOpeners() {
        boolean result = IOpeners.super.clearOpeners();
        Set<UUID> clientOpeners = this.getClientOpeners();
        if (clientOpeners != null && !clientOpeners.isEmpty()) {
            clientOpeners.clear();
            this.markChanged();
            return true;
        }
        return result;
    }

    default public boolean hasClientOpened(Player player) {
        return this.hasClientOpened(player.getUUID());
    }

    default public boolean hasClientOpened(UUID uuid) {
        if (this.isClientOpened()) {
            return true;
        }
        Set<UUID> clientOpeners = this.getClientOpeners();
        return clientOpeners != null && !clientOpeners.isEmpty() && clientOpeners.contains(uuid);
    }
}

