/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.capability;

import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import xfacthd.framedblocks.common.blockentity.special.FramedTankBlockEntity;

public final class TankFluidHandler
implements IFluidHandler {
    public static final int CAPACITY = 16000;
    public static final String FLUID_NBT_KEY = "fluid";
    private final FramedTankBlockEntity blockEntity;
    private FluidStack fluid = FluidStack.EMPTY;

    public TankFluidHandler(FramedTankBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return tank == 0 ? this.fluid : FluidStack.EMPTY;
    }

    public int getTankCapacity(int tank) {
        return tank == 0 ? 16000 : 0;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return tank == 0;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty() && (this.fluid.isEmpty() || FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.fluid))) {
            int toFill = Math.min(16000 - this.fluid.getAmount(), resource.getAmount());
            if (toFill > 0 && action.execute()) {
                if (this.fluid.isEmpty()) {
                    this.fluid = resource.copyWithAmount(toFill);
                } else {
                    this.fluid.grow(toFill);
                }
            }
            return toFill;
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!resource.isEmpty() && FluidStack.isSameFluidSameComponents((FluidStack)resource, (FluidStack)this.fluid)) {
            return this.drain(resource.getAmount(), action);
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int toDrain;
        if (maxDrain > 0 && !this.fluid.isEmpty() && (toDrain = Math.min(maxDrain, this.fluid.getAmount())) > 0) {
            if (action.execute()) {
                if (toDrain == this.fluid.getAmount()) {
                    this.fluid = FluidStack.EMPTY;
                } else {
                    this.fluid.shrink(toDrain);
                }
                this.onContentsChanged();
            }
            return this.fluid.copyWithAmount(toDrain);
        }
        return FluidStack.EMPTY;
    }

    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
        this.onContentsChanged();
    }

    public FluidStack getFluid() {
        return this.fluid;
    }

    private void onContentsChanged() {
        this.blockEntity.onTankContentsChanged();
    }

    public void load(CompoundTag tag, HolderLookup.Provider provider) {
        this.fluid = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound(FLUID_NBT_KEY));
    }

    public void save(CompoundTag nbt, HolderLookup.Provider provider) {
        if (!this.fluid.isEmpty()) {
            nbt.put(FLUID_NBT_KEY, this.fluid.save(provider));
        }
    }
}

