/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public enum EmptyBlockAndTintGetter implements BlockAndTintGetter
{
    INSTANCE;

    private static final LightChunkGetter EMPTY_LIGHT_CHUNK_GETTER;
    private static final LevelLightEngine EMPTY_LIGHT_ENGINE;

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pPos) {
        return null;
    }

    public BlockState getBlockState(BlockPos pPos) {
        return Blocks.AIR.defaultBlockState();
    }

    public FluidState getFluidState(BlockPos pPos) {
        return Fluids.EMPTY.defaultFluidState();
    }

    public LevelLightEngine getLightEngine() {
        return EMPTY_LIGHT_ENGINE;
    }

    public int getBlockTint(BlockPos pBlockPos, ColorResolver pColorResolver) {
        return -1;
    }

    public int getMinBuildHeight() {
        return 0;
    }

    public int getHeight() {
        return 0;
    }

    public float getShade(Direction pDirection, boolean pShade) {
        return 1.0f;
    }

    static {
        EMPTY_LIGHT_CHUNK_GETTER = new LightChunkGetter(){

            @Nullable
            public LightChunk getChunkForLighting(int pChunkX, int pChunkZ) {
                return null;
            }

            public BlockGetter getLevel() {
                return INSTANCE;
            }
        };
        EMPTY_LIGHT_ENGINE = new LevelLightEngine(EMPTY_LIGHT_CHUNK_GETTER, false, false);
    }
}

