/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.block.render;

import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.camo.CamoClientHandler;
import xfacthd.framedblocks.api.camo.CamoContainer;
import xfacthd.framedblocks.api.camo.CamoContent;

public final class ParticleHelper {
    public static void spawnLandingParticles(CamoContainer<?, ?> camo, ServerLevel level, BlockPos pos, LivingEntity entity, int count) {
        ParticleHelper.spawnLandingParticles(camo.getContent(), level, pos, entity, count);
    }

    public static void spawnLandingParticles(CamoContent<?> camo, ServerLevel level, BlockPos pos, LivingEntity entity, int count) {
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        BlockPos entityPos = entity.blockPosition();
        if (pos.getX() != entityPos.getX() || pos.getZ() != entityPos.getZ()) {
            double offX = x - (double)pos.getX() - 0.5;
            double offZ = z - (double)pos.getZ() - 0.5;
            double maxOff = Math.max(Math.abs(offX), Math.abs(offZ));
            x = (double)pos.getX() + 0.5 + offX / maxOff * 0.5;
            z = (double)pos.getZ() + 0.5 + offZ / maxOff * 0.5;
        }
        ParticleOptions options = camo.makeRunningLandingParticles(pos);
        level.sendParticles(options, x, y, z, count, 0.0, 0.0, 0.0, 0.15);
    }

    public static void spawnRunningParticles(CamoContainer<?, ?> camo, Level level, BlockPos pos, Entity entity) {
        ParticleHelper.spawnRunningParticles(camo.getContent(), level, pos, entity);
    }

    public static void spawnRunningParticles(CamoContent<?> camo, Level level, BlockPos pos, Entity entity) {
        Vec3 delta = entity.getDeltaMovement();
        BlockPos enityPos = entity.blockPosition();
        double x = entity.getRandomX(0.5);
        double z = entity.getRandomZ(0.5);
        if (enityPos.getX() != pos.getX()) {
            x = Mth.clamp((double)x, (double)pos.getX(), (double)((double)pos.getX() + 1.0));
        }
        if (enityPos.getZ() != pos.getZ()) {
            z = Mth.clamp((double)z, (double)pos.getZ(), (double)((double)pos.getZ() + 1.0));
        }
        ParticleOptions options = camo.makeRunningLandingParticles(pos);
        level.addParticle(options, x, entity.getY() + 0.1, z, delta.x * -4.0, 1.5, delta.z * -4.0);
    }

    private ParticleHelper() {
    }

    public static final class Client {
        public static void addHitEffects(BlockState state, Level level, BlockHitResult target, CamoContent<?> camo, ParticleEngine engine) {
            BlockPos pos = target.getBlockPos();
            Direction side = target.getDirection();
            double bx = pos.getX();
            double by = pos.getY();
            double bz = pos.getZ();
            AABB aabb = state.getShape((BlockGetter)level, pos).bounds();
            double x = bx + engine.random.nextDouble() * (aabb.maxX - aabb.minX - 0.2) + 0.1 + aabb.minX;
            double y = by + engine.random.nextDouble() * (aabb.maxY - aabb.minY - 0.2) + 0.1 + aabb.minY;
            double z = bz + engine.random.nextDouble() * (aabb.maxZ - aabb.minZ - 0.2) + 0.1 + aabb.minZ;
            switch (side) {
                case DOWN: {
                    y = by + aabb.minY - (double)0.1f;
                    break;
                }
                case UP: {
                    y = by + aabb.maxY + (double)0.1f;
                    break;
                }
                case NORTH: {
                    z = bz + aabb.minZ - (double)0.1f;
                    break;
                }
                case SOUTH: {
                    z = bz + aabb.maxZ + (double)0.1f;
                    break;
                }
                case WEST: {
                    x = bx + aabb.minX - (double)0.1f;
                    break;
                }
                case EAST: {
                    x = bx + aabb.maxX + (double)0.1f;
                }
            }
            CamoClientHandler<?> handler = camo.getClientHandler();
            engine.add(handler.makeHitDestroyParticle((ClientLevel)level, x, y, z, 0.0, 0.0, 0.0, camo, pos).setPower(0.2f).scale(0.6f));
        }

        public static void addDestroyEffects(BlockState state, Level level, BlockPos pos, CamoContent<?> camo, ParticleEngine engine) {
            CamoClientHandler<?> handler = camo.getClientHandler();
            List boxes = state.getShape((BlockGetter)level, pos).toAabbs();
            double countMult = 1.0 / (double)boxes.size();
            boxes.forEach(aabb -> {
                double sizeX = Math.min(1.0, aabb.maxX - aabb.minX);
                double sizeY = Math.min(1.0, aabb.maxY - aabb.minY);
                double sizeZ = Math.min(1.0, aabb.maxZ - aabb.minZ);
                int xCount = Math.max(2, Mth.ceil((double)(sizeX / 0.25 * countMult)));
                int yCount = Math.max(2, Mth.ceil((double)(sizeY / 0.25 * countMult)));
                int zCount = Math.max(2, Mth.ceil((double)(sizeZ / 0.25 * countMult)));
                for (int iX = 0; iX < xCount; ++iX) {
                    for (int iY = 0; iY < yCount; ++iY) {
                        for (int iZ = 0; iZ < zCount; ++iZ) {
                            double offX = ((double)iX + 0.5) / (double)xCount;
                            double offY = ((double)iY + 0.5) / (double)yCount;
                            double offZ = ((double)iZ + 0.5) / (double)zCount;
                            double x = (double)pos.getX() + offX * sizeX + aabb.minX;
                            double y = (double)pos.getY() + offY * sizeY + aabb.minY;
                            double z = (double)pos.getZ() + offZ * sizeZ + aabb.minZ;
                            engine.add(handler.makeHitDestroyParticle((ClientLevel)level, x, y, z, offX - 0.5, offY - 0.5, offZ - 0.5, camo, pos));
                        }
                    }
                }
            });
        }

        private Client() {
        }
    }
}

