/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.pumpjack;

import com.jesz.createdieselgenerators.CDGPartialModels;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackBearingBlockEntity;
import com.jesz.createdieselgenerators.content.pumpjack.PumpjackCrankBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;

public class PumpjackCrankRenderer
extends ShaftRenderer<PumpjackCrankBlockEntity> {
    public PumpjackCrankRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(PumpjackCrankBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (VisualizationManager.supportsVisualization((LevelAccessor)be.getLevel())) {
            return;
        }
        BlockState blockState = be.getBlockState();
        BlockPos pos = be.getBlockPos();
        float angle = AngleHelper.angleLerp((double)partialTicks, (double)be.prevAngle, (double)be.angle);
        boolean isXAxis = ((Direction)blockState.getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getAxis() == Direction.Axis.X;
        double v = (double)(((isXAxis ? angle : -angle) + 90.0f) / 180.0f) * Math.PI;
        double sin = Math.sin(v) * (be.crankSize.getValue() == 0 ? 0.8125 : 1.125);
        double cos = Math.cos(v) * (be.crankSize.getValue() == 0 ? 0.8125 : 1.125);
        SuperByteBuffer crank = CachedBuffers.partial((PartialModel)(be.crankSize.getValue() == 0 ? CDGPartialModels.PUMPJACK_CRANK_SMALL : CDGPartialModels.PUMPJACK_CRANK_LARGE), (BlockState)blockState);
        SuperByteBuffer rod = CachedBuffers.partial((PartialModel)(be.crankSize.getValue() == 0 ? CDGPartialModels.PUMPJACK_CRANK_ROD_SMALL : CDGPartialModels.PUMPJACK_CRANK_ROD_LARGE), (BlockState)blockState);
        double dstY = -1000.0 - sin - 1.25 - (double)pos.getY();
        double dstX = (double)pos.getX() - cos - 0.5 - (double)pos.getX();
        double dstZ = (double)pos.getZ() - cos - 0.5 - (double)pos.getZ();
        if (be.bearingPos != null) {
            PumpjackBearingBlockEntity bearing = (PumpjackBearingBlockEntity)((Object)be.bearing.get());
            float interpolatedAngle = 0.0f;
            if (bearing != null) {
                interpolatedAngle = bearing.getInterpolatedAngle(partialTicks);
            }
            if (be.inPonderAngle != -2.1474836E9f) {
                interpolatedAngle = be.inPonderAngle;
            }
            if (!isXAxis) {
                interpolatedAngle *= -1.0f;
            }
            Vec2 crankBearingLocation = new Vec2((float)(be.crankBearingLocation.x * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI) - be.crankBearingLocation.y * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f, (float)(be.crankBearingLocation.x * Math.sin((double)(interpolatedAngle / 180.0f) * Math.PI) + be.crankBearingLocation.y * Math.cos((double)(interpolatedAngle / 180.0f) * Math.PI)) + 0.5f);
            crankBearingLocation = isXAxis ? crankBearingLocation.add(new Vec2((float)be.bearingPos.getX(), (float)be.bearingPos.getY())) : crankBearingLocation.add(new Vec2((float)be.bearingPos.getZ(), (float)be.bearingPos.getY()));
            dstY = (double)crankBearingLocation.y - sin - 1.25 - (double)pos.getY();
            dstX = (double)crankBearingLocation.x - cos - 0.5 - (double)pos.getX();
            dstZ = (double)crankBearingLocation.x - cos - 0.5 - (double)pos.getZ();
        }
        if (isXAxis) {
            ((SuperByteBuffer)crank.translate(0.5, 1.25, 0.0)).rotateZDegrees(angle);
            ((SuperByteBuffer)((SuperByteBuffer)rod.translate(0.5, 1.25, 0.0)).translate(cos, sin, 0.0)).rotateZDegrees((float)(Math.atan2(dstY, dstX) * 180.0 / Math.PI - 90.0));
        } else {
            ((SuperByteBuffer)((SuperByteBuffer)crank.translate(0.0, 1.25, 0.5)).rotateYDegrees(90.0f)).rotateZDegrees(angle);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)rod.translate(0.0, 1.25, 0.5)).translate(0.0, sin, cos)).rotateYDegrees(90.0f)).rotateZDegrees((float)(Math.atan2(dstZ, dstY) * 180.0 / Math.PI));
        }
        rod.light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        crank.light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
    }
}

