/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.oil_barrel;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.content.oil_barrel.OilBarrelBlock;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Objects;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class OilBarrelBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainer.Fluid,
IHaveGoggleInformation {
    protected IFluidHandler fluidCapability;
    protected FluidTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;

    public OilBarrelBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.refreshCapability();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(OilBarrelBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition)) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.hasLevel()) {
            return;
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    OilBarrelBlockEntity tankAt = (OilBarrelBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.getType(), (BlockGetter)this.level, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, tankAt.getBlockState().getBlock());
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public OilBarrelBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof OilBarrelBlockEntity) {
            return (OilBarrelBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * OilBarrelBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public void removeController(boolean keepFluids) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        OilBarrelBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, controllerBE.getBlockPos(), null));
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = tag.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (tag.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)tag, (String)"LastKnownPos");
        }
        if (tag.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)tag, (String)"Controller");
        }
        if (this.isController()) {
            this.width = tag.getInt("Size");
            this.height = tag.getInt("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * OilBarrelBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(registries, tag.getCompound("TankContent"));
        }
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.hasLevel()) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(OilBarrelBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.updateConnectivity) {
            tag.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            tag.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            tag.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.getController()));
        }
        if (this.isController()) {
            tag.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
            tag.putInt("Size", this.width);
            tag.putInt("Height", this.height);
        }
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            tag.putBoolean("LazySync", true);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.OIL_BARREL.get(), (be, context) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.onFluidStackChanged(this.tankInventory.getFluid());
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return (Direction.Axis)this.getBlockState().getValue(OilBarrelBlock.AXIS);
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return width * 4;
    }

    public int getMaxWidth() {
        return (Integer)CDGConfig.MAX_OIL_BARREL_WIDTH.get();
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return OilBarrelBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

