/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.items;

import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MultiBlockContainerBlockItem
extends BlockItem {
    BlockEntityType<?> type;

    public MultiBlockContainerBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public InteractionResult place(BlockPlaceContext ctx) {
        InteractionResult initialResult;
        if (this.type == null) {
            this.type = ((IBE)this.getBlock()).getBlockEntityType();
        }
        if (!(initialResult = super.place(ctx)).consumesAction()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos pos, Level level, Player player, ItemStack stack, BlockState state) {
        MinecraftServer minecraftserver = level.getServer();
        if (minecraftserver == null) {
            return false;
        }
        CustomData blockEntityData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blockEntityData != null) {
            CompoundTag nbt = blockEntityData.copyTag();
            nbt.remove("Size");
            nbt.remove("Height");
            nbt.remove("Controller");
            nbt.remove("LastKnownPos");
            stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)nbt));
        }
        return super.updateCustomBlockEntityTag(pos, level, player, stack, state);
    }

    private <T extends BlockEntity> void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.getPlayer();
        if (player == null) {
            return;
        }
        if (player.isSteppingCarefully()) {
            return;
        }
        Direction face = ctx.getClickedFace();
        ItemStack stack = ctx.getItemInHand();
        Level world = ctx.getLevel();
        BlockState placedOnState = world.getBlockState(placedOnPos = (pos = ctx.getClickedPos()).relative(face.getOpposite()));
        if (placedOnState.getBlock() != this.getBlock()) {
            return;
        }
        BlockEntity tankAt = ConnectivityHandler.partAt(this.type, (BlockGetter)world, (BlockPos)placedOnPos);
        if (tankAt == null) {
            return;
        }
        BlockEntity controllerBE = ((IMultiBlockEntityContainer)tankAt).getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = ((IMultiBlockEntityContainer)controllerBE).getWidth();
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        Direction.Axis blockAxis = ((IMultiBlockEntityContainer)tankAt).getMainConnectionAxis();
        if (face.getAxis() != blockAxis) {
            return;
        }
        Direction facing = Direction.fromAxisAndDirection((Direction.Axis)blockAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        BlockPos blockPos = startPos = face == facing.getOpposite() ? controllerBE.getBlockPos().relative(facing.getOpposite()) : controllerBE.getBlockPos().relative(facing, ((IMultiBlockEntityContainer)controllerBE).getHeight());
        if (VecHelper.getCoordinate((Vec3i)startPos, (Direction.Axis)blockAxis) != VecHelper.getCoordinate((Vec3i)pos, (Direction.Axis)blockAxis)) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = blockAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : (blockAxis == Direction.Axis.Y ? startPos.offset(xOffset, 0, zOffset) : startPos.offset(xOffset, zOffset, 0));
                blockState = world.getBlockState(offsetPos);
                if (blockState.getBlock() == this.getBlock()) continue;
                if (!blockState.canBeReplaced()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.isCreative() && stack.getCount() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = blockAxis == Direction.Axis.X ? startPos.offset(0, xOffset, zOffset) : (blockAxis == Direction.Axis.Y ? startPos.offset(xOffset, 0, zOffset) : startPos.offset(xOffset, zOffset, 0));
                blockState = world.getBlockState(offsetPos);
                if (blockState.getBlock() == this.getBlock()) continue;
                BlockPlaceContext context = BlockPlaceContext.at((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().putBoolean("SilenceTankSound", true);
                super.place(context);
                player.getPersistentData().remove("SilenceTankSound");
            }
        }
    }
}

