/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.diesel_engine.normal;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineSoundInstance;
import com.jesz.createdieselgenerators.content.diesel_engine.EngineUpgrades;
import com.jesz.createdieselgenerators.content.diesel_engine.IEngine;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineValueBox;
import com.simibubi.create.content.contraptions.bearing.WindmillBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class DieselEngineBlockEntity
extends GeneratingKineticBlockEntity
implements IEngine {
    ScrollOptionBehaviour<WindmillBearingBlockEntity.RotationDirection> movementDirection;
    float remainingTicks = 0.0f;
    EngineUpgrades upgrade = EngineUpgrades.EMPTY;
    SmartFluidTankBehaviour tank;
    private float lastCapacity;
    private float lastSpeed;
    @OnlyIn(value=Dist.CLIENT)
    protected EngineSoundInstance soundInstance;

    public DieselEngineBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.DIESEL_ENGINE.get(), (be, side) -> {
            if (side == null) {
                return be.tank.getCapability();
            }
            Direction facing = (Direction)be.getBlockState().getValue((Property)DieselEngineBlock.FACING);
            if (facing.getAxis().isVertical() ? side.getAxis() == (facing == Direction.UP ? Direction.Axis.X : Direction.Axis.Z) : side == Direction.DOWN) {
                return be.tank.getCapability();
            }
            return null;
        });
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putFloat("RemainingTicks", this.remainingTicks);
        tag.putString("Upgrade", this.upgrade.getId().toString());
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.remainingTicks = tag.getFloat("RemainingTicks");
        this.upgrade = EngineUpgrades.get(ResourceLocation.parse((String)tag.getString("Upgrade")));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.movementDirection = new ScrollOptionBehaviour(WindmillBearingBlockEntity.RotationDirection.class, (Component)CreateLang.translateDirect((String)"contraptions.windmill.rotation_direction", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new DieselEngineValueBox());
        this.movementDirection.withCallback(v -> {
            this.reActivateSource = true;
        });
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)1000);
        behaviours.add((BlockEntityBehaviour)this.movementDirection);
        behaviours.add((BlockEntityBehaviour)this.tank);
    }

    public float calculateAddedStressCapacity() {
        float capacity;
        this.lastCapacityProvided = capacity = this.upgrade.getCapacity(this.getFuelCapacity() * (1.0f / this.upgrade.getSpeed(this.getFuelSpeed(), this)) * this.getFuelSpeed(), this);
        return capacity;
    }

    public float getGeneratedSpeed() {
        if (!this.enabled()) {
            return 0.0f;
        }
        return DieselEngineBlockEntity.convertToDirection((float)((float)(this.movementDirection.getValue() == 1 ? -1 : 1) * this.upgrade.getSpeed(this.getFuelSpeed(), this)), (Direction)((Direction)this.getBlockState().getValue((Property)DieselEngineBlock.FACING)));
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (this.getGeneratedSpeed() == 0.0f) {
            return false;
        }
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tank.getCapability());
        return true;
    }

    public void tick() {
        super.tick();
        float fuelCapacity = this.upgrade.getCapacity(this.getFuelCapacity() * (1.0f / this.upgrade.getSpeed(this.getFuelSpeed(), this)) * this.getFuelSpeed(), this);
        if (!(this.level.isClientSide || this.lastSpeed == this.getGeneratedSpeed() && this.lastCapacity == fuelCapacity)) {
            this.reActivateSource = true;
            this.lastSpeed = this.getGeneratedSpeed();
            this.lastCapacity = fuelCapacity;
        }
        if (this.enabled()) {
            if (this.remainingTicks < 2.0f) {
                this.remainingTicks += 1.0f / this.getFuelBurnRate();
                this.tank.getPrimaryHandler().drain(1, IFluidHandler.FluidAction.EXECUTE);
            }
            if (this.remainingTicks >= 0.0f) {
                this.remainingTicks -= 1.0f;
            }
        }
        if (this.level.isClientSide) {
            CatnipServices.PLATFORM.executeOnClientOnly(() -> this::tickClient);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void tickClient() {
        if (this.enabled()) {
            if (this.soundInstance == null || this.soundInstance.isStopped()) {
                this.soundInstance = this.upgrade.createSoundInstance(this, Vec3.atCenterOf((Vec3i)this.getBlockPos()));
                Minecraft.getInstance().getSoundManager().play((SoundInstance)this.soundInstance);
            } else if (this.soundInstance.active()) {
                this.soundInstance.keepAlive();
                this.soundInstance.setPitch(this.upgrade.getPitchMultiplier(this) * this.getFuelSoundPitch());
                this.soundInstance.setVolume(this.upgrade.getVolume(this));
            }
        } else if (this.soundInstance != null) {
            this.soundInstance.fadeOut();
            this.soundInstance = null;
        }
    }

    @Override
    public float getRemainingTicks() {
        return this.remainingTicks;
    }

    @Override
    public SmartBlockEntity self() {
        return this;
    }

    @Override
    public FluidTank getTank() {
        return this.tank.getPrimaryHandler();
    }

    @Override
    public EngineUpgrades getUpgrade() {
        return this.upgrade;
    }

    @Override
    public void setUpgrade(EngineUpgrades upgrade) {
        this.upgrade = upgrade;
    }
}

