/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.bulk_fermenter;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.CDGRecipes;
import com.jesz.createdieselgenerators.content.bulk_fermenter.BulkFermentingRecipe;
import com.jesz.createdieselgenerators.content.bulk_fermenter.IMultiBlockEntityContainerFluidItem;
import com.jesz.createdieselgenerators.content.distillation.DistillationRecipe;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.VersionedInventoryWrapper;
import com.simibubi.create.foundation.recipe.RecipeFinder;
import com.simibubi.create.foundation.utility.CreateLang;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class BulkFermenterBlockEntity
extends SmartBlockEntity
implements IMultiBlockEntityContainerFluidItem,
IHaveGoggleInformation {
    private static final int MAX_SIZE = 3;
    IItemHandler itemCapability;
    public ItemStackHandler inventory;
    IFluidHandler fluidCapability;
    BulkFermenterFluidHandler tankInventory;
    BlockPos controller;
    BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    protected boolean updateCapability = false;
    int width = 1;
    int height = 1;
    private static final int SYNC_RATE = 8;
    int syncCooldown;
    boolean queuedSync;
    public int processingTime = -1;
    BulkFermentingRecipe currentRecipe;
    BlazeBurnerBlock.HeatLevel highestHeatLevel = BlazeBurnerBlock.HeatLevel.NONE;
    static final Object RECIPE_CACHE_KEY = new Object();

    public BulkFermenterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.inventory = new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                List<Recipe<?>> r = BulkFermenterBlockEntity.this.getMatchingRecipes();
                if (!r.contains((Object)BulkFermenterBlockEntity.this.currentRecipe)) {
                    BulkFermenterBlockEntity.this.processingTime = -1;
                }
                if (BulkFermenterBlockEntity.this.processingTime == -1 && !r.isEmpty()) {
                    BulkFermenterBlockEntity.this.currentRecipe = (BulkFermentingRecipe)r.get(0);
                    BulkFermenterBlockEntity.this.startProcessing();
                }
                if (!((BulkFermenterBlockEntity)BulkFermenterBlockEntity.this).level.isClientSide) {
                    BulkFermenterBlockEntity.this.setChanged();
                    BulkFermenterBlockEntity.this.sendData();
                }
            }
        };
        this.refreshCapability();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected BulkFermenterFluidHandler createInventory() {
        return new BulkFermenterFluidHandler(6, BulkFermenterBlockEntity.getCapacityMultiplier(), f -> this.onFluidStackChanged());
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.level.isClientSide) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        ConnectivityHandler.formMulti((BlockEntity)this);
    }

    private void startProcessing() {
        if (this.currentRecipe == null) {
            return;
        }
        this.processingTime = this.currentRecipe.getProcessingDuration();
        this.sendData();
    }

    public void tick() {
        if (this.isController()) {
            List<Recipe<?>> r;
            if (this.processingTime >= 0) {
                if (!this.level.isClientSide && this.processingTime % 20 == 0 && new Random().nextInt() % 4 == 0) {
                    this.level.playSound(null, this.worldPosition.offset(this.width / 2, this.height / 2, this.width / 2), SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.15f, 0.75f);
                }
                if (this.processingTime == 1) {
                    this.level.playSound(null, this.worldPosition.offset(this.width / 2, this.height / 2, this.width / 2), SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.15f, 0.75f);
                }
                if (this.currentRecipe == null) {
                    r = this.getMatchingRecipes();
                    if (r.isEmpty()) {
                        this.processingTime = -1;
                    } else {
                        this.currentRecipe = (BulkFermentingRecipe)r.get(0);
                    }
                } else if (this.processingTime == 0 && !this.level.isClientSide) {
                    this.currentRecipe.apply(this, false);
                    this.processingTime = -1;
                } else {
                    this.processingTime = (int)Math.max(0.0, (double)this.processingTime - Math.sqrt(this.width * this.height));
                }
            }
            if (this.processingTime == -1 && this.currentRecipe != null) {
                r = this.getMatchingRecipes();
                this.currentRecipe = null;
                if (!r.contains((Object)this.currentRecipe)) {
                    this.processingTime = -1;
                }
                if (this.processingTime == -1 && !r.isEmpty()) {
                    this.currentRecipe = (BulkFermentingRecipe)r.get(0);
                    this.startProcessing();
                }
                if (!this.level.isClientSide) {
                    this.setChanged();
                    this.sendData();
                }
            }
        }
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.getBlockPos();
        } else if (!this.lastKnownPos.equals((Object)this.worldPosition) && this.worldPosition != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        if (this.updateCapability) {
            this.updateCapability = false;
            this.refreshCapability();
        }
    }

    protected List<Recipe<?>> getMatchingRecipes() {
        List list = RecipeFinder.get((Object)RECIPE_CACHE_KEY, (Level)this.level, recipe -> recipe.value().getType() == CDGRecipes.BULK_FERMENTING.getType());
        return list.stream().map(RecipeHolder::value).sorted((r1, r2) -> {
            if (r1 instanceof DistillationRecipe) {
                DistillationRecipe recipe1 = (DistillationRecipe)((Object)r1);
                if (r2 instanceof DistillationRecipe) {
                    DistillationRecipe recipe2 = (DistillationRecipe)((Object)r2);
                    return recipe2.getRequiredHeat().ordinal() - recipe1.getRequiredHeat().ordinal();
                }
            }
            return 0;
        }).filter(r -> ((BulkFermentingRecipe)((Object)r)).apply(this, true)).collect(Collectors.toList());
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.worldPosition.getX() == this.controller.getX() && this.worldPosition.getY() == this.controller.getY() && this.worldPosition.getZ() == this.controller.getZ();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.worldPosition;
    }

    protected void onFluidStackChanged() {
        if (!this.hasLevel()) {
            return;
        }
        List<Recipe<?>> r = this.getMatchingRecipes();
        if (!r.contains((Object)this.currentRecipe)) {
            this.processingTime = -1;
        }
        if (this.processingTime == -1 && !r.isEmpty()) {
            this.currentRecipe = (BulkFermentingRecipe)r.get(0);
            this.startProcessing();
        }
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    BulkFermenterBlockEntity tankAt = (BulkFermenterBlockEntity)ConnectivityHandler.partAt((BlockEntityType)this.getType(), (BlockGetter)this.level, (BlockPos)pos);
                    if (tankAt == null) continue;
                    this.level.updateNeighbourForOutputSignal(pos, tankAt.getBlockState().getBlock());
                }
            }
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public BulkFermenterBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.controller);
        if (blockEntity instanceof BulkFermenterBlockEntity) {
            return (BulkFermenterBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * BulkFermenterBlockEntity.getCapacityMultiplier());
    }

    public void removeController(boolean keepContents) {
        if (this.level.isClientSide) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepContents) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged();
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setController(BlockPos controller) {
        if (this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.setChanged();
        this.sendData();
    }

    private void refreshCapability() {
        this.fluidCapability = this.handlerForCapability();
        this.invalidateCapabilities();
    }

    void initCapability() {
        if (!this.isController()) {
            BulkFermenterBlockEntity controllerBE = this.getControllerBE();
            if (controllerBE == null) {
                return;
            }
            controllerBE.initCapability();
            this.itemCapability = controllerBE.itemCapability;
            return;
        }
        IItemHandlerModifiable[] inventories = new IItemHandlerModifiable[this.height * this.width * this.width];
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos vaultPos = this.worldPosition.offset(xOffset, yOffset, zOffset);
                    BulkFermenterBlockEntity tankAt = (BulkFermenterBlockEntity)ConnectivityHandler.partAt((BlockEntityType)((BlockEntityType)CDGBlockEntityTypes.BULK_FERMENTER.get()), (BlockGetter)this.level, (BlockPos)vaultPos);
                    inventories[yOffset * this.width * this.width + xOffset * this.width + zOffset] = tankAt != null ? tankAt.inventory : new ItemStackHandler();
                }
            }
        }
        VersionedInventoryWrapper itemHandler = new VersionedInventoryWrapper((IItemHandlerModifiable)new CombinedInvWrapper(this, inventories){

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                int i;
                for (i = 0; i < this.getSlots(); ++i) {
                    if (!ItemStack.isSameItemSameComponents((ItemStack)this.getStackInSlot(i), (ItemStack)stack)) continue;
                    int space = Math.min(stack.getMaxStackSize(), this.getSlotLimit(i)) - this.getStackInSlot(i).getCount();
                    if (space == 0) {
                        return stack;
                    }
                    return super.insertItem(i, stack, simulate).copyWithCount(stack.getCount() - Math.min(stack.getCount(), space));
                }
                for (i = 0; i < this.getSlots(); ++i) {
                    if (!this.getStackInSlot(i).isEmpty()) continue;
                    return super.insertItem(i, stack, simulate);
                }
                return stack;
            }
        });
        this.itemCapability = itemHandler;
        this.invalidateCapabilities();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new BulkFermenterFluidHandler(0, 0, fs -> {}));
    }

    public BlockPos getController() {
        return this.isController() ? this.worldPosition : this.controller;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        boolean changeOfController;
        super.read(tag, registries, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        this.updateConnectivity = tag.contains("Uninitialized");
        this.controller = null;
        this.lastKnownPos = null;
        if (tag.contains("LastKnownPos")) {
            this.lastKnownPos = NBTHelper.readBlockPos((CompoundTag)tag, (String)"LastKnownPos");
        }
        if (tag.contains("Controller")) {
            this.controller = NBTHelper.readBlockPos((CompoundTag)tag, (String)"Controller");
        }
        if (this.isController()) {
            this.width = tag.getInt("Size");
            this.height = tag.getInt("Height");
            this.highestHeatLevel = BlazeBurnerBlock.HeatLevel.values()[tag.getInt("Heat")];
            this.tankInventory.setCapacity(this.getTotalTankSize() * BulkFermenterBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(registries, tag.getCompound("TankContent"));
            this.processingTime = tag.getInt("ProcessingTime");
        }
        this.inventory.deserializeNBT(registries, tag.getCompound("Inventory"));
        this.updateCapability = true;
        if (!clientPacket) {
            return;
        }
        boolean bl = changeOfController = !Objects.equals(controllerBefore, this.controller);
        if (this.hasLevel() && (changeOfController || prevSize != this.width || prevHeight != this.height)) {
            this.level.setBlocksDirty(this.getBlockPos(), Blocks.AIR.defaultBlockState(), this.getBlockState());
            if (this.isController()) {
                this.tankInventory.setCapacity(BulkFermenterBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        if (this.updateConnectivity) {
            tag.putBoolean("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            tag.put("LastKnownPos", NbtUtils.writeBlockPos((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            tag.put("Controller", NbtUtils.writeBlockPos((BlockPos)this.controller));
        }
        if (this.isController()) {
            tag.put("TankContent", (Tag)this.tankInventory.writeToNBT(registries, new CompoundTag()));
            tag.putInt("Size", this.width);
            tag.putInt("Height", this.height);
            tag.putInt("ProcessingTime", this.processingTime);
            tag.putInt("Heat", this.highestHeatLevel.ordinal());
        }
        tag.put("Inventory", (Tag)this.inventory.serializeNBT(registries));
        if (!clientPacket) {
            return;
        }
        if (this.queuedSync) {
            tag.putBoolean("LazySync", true);
        }
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.BULK_FERMENTER.get(), (be, side) -> {
            if (be.fluidCapability == null) {
                be.refreshCapability();
            }
            return be.fluidCapability;
        });
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, (BlockEntityType)CDGBlockEntityTypes.BULK_FERMENTER.get(), (be, side) -> {
            be.initCapability();
            return be.itemCapability;
        });
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getCapacityMultiplier() {
        return 1000;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        this.onFluidStackChanged();
        this.setChanged();
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return BulkFermenterBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return (IFluidTank)this.tankInventory.tanks.get(tank);
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluidInTank(tank).copy();
    }

    public BulkFermentingRecipe getRecipe() {
        return this.currentRecipe;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        BulkFermenterBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            return false;
        }
        IItemHandler items = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, controller.getBlockPos(), null);
        IFluidHandler fluids = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, controller.getBlockPos(), null);
        if (items == null || fluids == null) {
            return false;
        }
        boolean isEmpty = true;
        CreateLang.translate((String)"gui.goggles.basin_contents", (Object[])new Object[0]).forGoggles(tooltip);
        HashMap<Item, Integer> allItems = new HashMap<Item, Integer>();
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stackInSlot = items.getStackInSlot(i);
            if (stackInSlot.isEmpty()) continue;
            if (allItems.containsKey(stackInSlot.getItem())) {
                allItems.replace(stackInSlot.getItem(), stackInSlot.getCount() + (Integer)allItems.get(stackInSlot.getItem()));
            } else {
                allItems.put(stackInSlot.getItem(), stackInSlot.getCount());
            }
            isEmpty = false;
        }
        for (Map.Entry e : allItems.entrySet()) {
            CreateLang.text((String)"").add(Component.translatable((String)((Item)e.getKey()).getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + String.valueOf(e.getValue()))).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        LangBuilder mb = CreateLang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]);
        for (int i = 0; i < fluids.getTanks(); ++i) {
            FluidStack fluidStack = fluids.getFluidInTank(i);
            if (fluidStack.isEmpty()) continue;
            CreateLang.text((String)"").add(CreateLang.fluidName((FluidStack)fluidStack).add(CreateLang.text((String)" ")).style(ChatFormatting.GRAY).add(CreateLang.number((double)fluidStack.getAmount()).add(mb).style(ChatFormatting.BLUE))).forGoggles(tooltip, 1);
            isEmpty = false;
        }
        if (isEmpty) {
            tooltip.remove(0);
        }
        return true;
    }

    public void updateHeat() {
        int width;
        BulkFermenterBlockEntity controller = this.getControllerBE();
        if (controller == null) {
            width = 1;
        } else {
            if (controller != this) {
                controller.updateHeat();
                return;
            }
            width = controller.width;
        }
        BlazeBurnerBlock.HeatLevel highestHeat = BlazeBurnerBlock.HeatLevel.NONE;
        for (int xOffset = 0; xOffset < width; ++xOffset) {
            for (int zOffset = 0; zOffset < width; ++zOffset) {
                BlockPos pos = this.getController().offset(xOffset, -1, zOffset);
                BlockState blockState = this.level.getBlockState(pos);
                BlazeBurnerBlock.HeatLevel heat = BasinBlockEntity.getHeatLevelOf((BlockState)blockState);
                if (highestHeat.isAtLeast(heat)) continue;
                highestHeat = heat;
            }
        }
        this.highestHeatLevel = highestHeat;
        List<Recipe<?>> r = this.getMatchingRecipes();
        if (!r.contains((Object)this.currentRecipe)) {
            this.processingTime = -1;
        }
        if (this.processingTime == -1 && !r.isEmpty()) {
            this.currentRecipe = (BulkFermentingRecipe)r.get(0);
            this.startProcessing();
        }
        if (!this.level.isClientSide) {
            this.setChanged();
            this.sendData();
        }
    }

    public static class BulkFermenterFluidHandler
    implements IFluidHandler {
        int tankCount;
        NonNullList<FluidTank> tanks = NonNullList.create();
        Consumer<FluidStack> updateCallback;

        public BulkFermenterFluidHandler(int tankCount, int capacity, Consumer<FluidStack> updateCallback) {
            for (int i = 0; i < tankCount; ++i) {
                this.tanks.add((Object)new FluidTank(capacity));
            }
            this.tankCount = tankCount;
            this.updateCallback = updateCallback;
        }

        public int getTanks() {
            return this.tankCount;
        }

        public FluidStack getFluidInTank(int tank) {
            return ((FluidTank)this.tanks.get(tank)).getFluid();
        }

        public int getTankCapacity(int tank) {
            return ((FluidTank)this.tanks.get(tank)).getCapacity();
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            for (FluidTank tank : this.tanks) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)resource)) continue;
                int result = tank.fill(resource, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            for (FluidTank tank : this.tanks) {
                if (!tank.getFluid().isEmpty()) continue;
                int result = tank.fill(resource, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            for (FluidTank tank : this.tanks) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)resource)) continue;
                FluidStack result = tank.drain(resource, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            for (FluidTank tank : this.tanks) {
                if (tank.getFluid().isEmpty()) continue;
                FluidStack result = tank.drain(maxDrain, action);
                if (action.execute()) {
                    this.updateCallback.accept(tank.getFluid());
                }
                return result;
            }
            return FluidStack.EMPTY;
        }

        public CompoundTag writeToNBT(HolderLookup.Provider registries, CompoundTag compound) {
            ListTag list = new ListTag();
            for (FluidTank tank : this.tanks) {
                list.add((Object)tank.writeToNBT(registries, new CompoundTag()));
            }
            compound.put("Tanks", (Tag)list);
            return compound;
        }

        public void readFromNBT(HolderLookup.Provider registries, CompoundTag compound) {
            for (int i = 0; i < this.tanks.size(); ++i) {
                FluidTank tank = (FluidTank)this.tanks.get(i);
                tank.readFromNBT(registries, compound.getList("Tanks", 10).getCompound(i));
            }
        }

        public void setCapacity(int capacity) {
            for (FluidTank tank : this.tanks) {
                tank.setCapacity(capacity);
                tank.drain(Math.max(0, tank.getFluidAmount() - capacity), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }
}

