/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.foundation;

import com.cake.trading_floor.foundation.TFPlatformPackets;
import java.util.Objects;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ParticleEmitter {
    final SimpleParticleType particleType;
    AABB volume = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    Vec3 randomVelocityStrength = Vec3.ZERO;
    Vec3 emitFromCenterStrength = Vec3.ZERO;
    int sendPacketRange = 16;

    public ParticleEmitter(SimpleParticleType particleType) {
        this.particleType = particleType;
    }

    public void emitToClients(ServerLevel level, Vec3 origin, int count) {
        TFPlatformPackets.sendEmitParticlesToNear(level, this, origin, count, BlockPos.containing((Position)origin), this.sendPacketRange);
    }

    public void emitParticles(ClientLevel level, Vec3 origin, int count) {
        this.emitWithConsumer((arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6) -> ((ClientLevel)level).addParticle(arg_0, arg_1, arg_2, arg_3, arg_4, arg_5, arg_6), origin, count);
    }

    public void emitWithConsumer(ParticleDataConsumer consumer, Vec3 origin, int count) {
        boolean hasAABB = !this.volume.equals((Object)new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        boolean doEmitFromCenter = !this.emitFromCenterStrength.equals((Object)Vec3.ZERO);
        boolean hasVelocity = !this.randomVelocityStrength.equals((Object)Vec3.ZERO);
        for (int i = 0; i < count; ++i) {
            Vec3 position = this.generateRandomPosition(hasAABB, origin);
            Vec3 velocity = hasVelocity ? this.generateRandomVelocityOfPosition(doEmitFromCenter, origin, position) : Vec3.ZERO;
            consumer.addParticle(this.particleType, position.x, position.y, position.z, velocity.x, velocity.y, velocity.z);
        }
    }

    protected Vec3 generateRandomVelocityOfPosition(boolean doEmitFromCenter, Vec3 origin, Vec3 position) {
        Vec3 baseVelocity = new Vec3(this.randomVelocityStrength.x * Math.random(), this.randomVelocityStrength.y * Math.random(), this.randomVelocityStrength.z * Math.random());
        if (!doEmitFromCenter) {
            return baseVelocity;
        }
        Vec3 offset = position.subtract(origin).normalize();
        if (offset.equals((Object)Vec3.ZERO)) {
            return baseVelocity;
        }
        baseVelocity = baseVelocity.add(this.emitFromCenterStrength.x * offset.x, this.emitFromCenterStrength.y * offset.y, this.emitFromCenterStrength.z * offset.z);
        return baseVelocity;
    }

    protected Vec3 generateRandomPosition(boolean hasAABB, Vec3 origin) {
        if (!hasAABB) {
            return origin;
        }
        Vec3 offset = new Vec3(this.volume.minX + this.volume.getXsize() * Math.random(), this.volume.minY + this.volume.getYsize() * Math.random(), this.volume.minZ + this.volume.getZsize() * Math.random());
        return origin.add(offset);
    }

    public ParticleEmitter setVolume(AABB volume) {
        this.volume = volume;
        return this;
    }

    public ParticleEmitter setRandomVelocityStrength(Vec3 randomVelocityStrength) {
        this.randomVelocityStrength = randomVelocityStrength;
        return this;
    }

    public ParticleEmitter setRandomVelocityStrength(float randomVelocityStrength) {
        return this.setRandomVelocityStrength(new Vec3((double)randomVelocityStrength, (double)randomVelocityStrength, (double)randomVelocityStrength));
    }

    public ParticleEmitter setEmitFromCenterStrength(Vec3 emitFromCenterStrength) {
        this.emitFromCenterStrength = emitFromCenterStrength;
        return this;
    }

    public ParticleEmitter setEmitFromCenterStrength(float emitFromCenterStrength) {
        return this.setRandomVelocityStrength(new Vec3((double)emitFromCenterStrength, (double)emitFromCenterStrength, (double)emitFromCenterStrength));
    }

    public ParticleEmitter setSendPacketRange(int sendPacketRange) {
        this.sendPacketRange = sendPacketRange;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ParticleEmitter)) {
            return false;
        }
        ParticleEmitter that = (ParticleEmitter)o;
        return Objects.equals(this.emitFromCenterStrength, that.emitFromCenterStrength) && this.sendPacketRange == that.sendPacketRange && Objects.equals(this.particleType, that.particleType) && Objects.equals(this.volume, that.volume) && Objects.equals(this.randomVelocityStrength, that.randomVelocityStrength);
    }

    public int hashCode() {
        return Objects.hash(BuiltInRegistries.PARTICLE_TYPE.getKey((Object)this.particleType), this.volume, this.randomVelocityStrength, this.emitFromCenterStrength, this.sendPacketRange);
    }

    public static interface ParticleDataConsumer {
        public void addParticle(SimpleParticleType var1, double var2, double var4, double var6, double var8, double var10, double var12);
    }
}

