/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor;

import com.cake.trading_floor.Config;
import com.cake.trading_floor.TradingFloorData;
import com.cake.trading_floor.content.trading_depot.TradingDepotBlockEntity;
import com.cake.trading_floor.foundation.advancement.TFAdvancements;
import com.cake.trading_floor.foundation.ponder_scenes.TFPonderPlugin;
import com.cake.trading_floor.network.TFPackets;
import com.cake.trading_floor.registry.TFDisplaySources;
import com.cake.trading_floor.registry.TFLangEntries;
import com.cake.trading_floor.registry.TFParticleEmitters;
import com.cake.trading_floor.registry.TFRegistry;
import com.cake.trading_floor.registry.TFTriggers;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.registries.RegisterEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="trading_floor")
public class TradingFloor {
    public static final String MOD_ID = "trading_floor";
    public static final String NAME = "Create: Trading Floor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Create: Trading Floor");
    public static final CreateRegistrate REGISTRATE = CreateRegistrate.create((String)"trading_floor").setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));

    public TradingFloor(IEventBus eventBus, ModContainer modContainer) {
        this.init(eventBus, modContainer);
    }

    public void init(IEventBus eventBus, ModContainer modContainer) {
        REGISTRATE.registerEventListeners(eventBus);
        TFPackets.register();
        TFRegistry.init();
        TFParticleEmitters.register();
        TFLangEntries.addEntries();
        TFDisplaySources.register();
        TFParticleEmitters.register();
        TFDisplaySources.register();
        REGISTRATE.addDataGenerator(ProviderType.LANG, TradingFloor::addPostInitLang);
        eventBus.addListener(TradingFloorData::gatherData);
        eventBus.addListener(TradingFloor::registerCapabilities);
        eventBus.addListener(TradingFloor::clientInit);
        eventBus.addListener(TradingFloor::onRegister);
        eventBus.addListener(TradingFloor::commonInit);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        LOGGER.info("Finished Initialisation For Mod: trading_floor");
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        TradingDepotBlockEntity.registerCapabilities(event);
    }

    public static void onRegister(RegisterEvent event) {
        if (event.getRegistry() == BuiltInRegistries.TRIGGER_TYPES) {
            TFAdvancements.register();
            TFTriggers.register();
        }
    }

    public static void clientInit(FMLClientSetupEvent event) {
        PonderIndex.addPlugin((PonderPlugin)new TFPonderPlugin());
    }

    public static ResourceLocation asResource(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }

    private static void addPostInitLang(RegistrateLangProvider registrateLangProvider) {
        PonderIndex.addPlugin((PonderPlugin)new TFPonderPlugin());
        PonderIndex.getLangAccess().provideLang(MOD_ID, (arg_0, arg_1) -> ((RegistrateLangProvider)registrateLangProvider).add(arg_0, arg_1));
        TFAdvancements.provideLang((arg_0, arg_1) -> ((RegistrateLangProvider)registrateLangProvider).add(arg_0, arg_1));
    }

    public static void commonInit(FMLCommonSetupEvent event) {
        event.enqueueWork(TFAdvancements::register);
    }

    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            TradingDepotBlockEntity.registerCapabilities(event);
        }
    }
}

