/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.util;

import com.ldtteam.domumornamentum.util.SingleBlockBlockReader;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleBlockLevelReader
extends SingleBlockBlockReader
implements LevelReader {
    @Nullable
    private final LevelReader reader;

    public SingleBlockLevelReader(BlockState state) {
        this(state, (LevelReader)null);
    }

    public SingleBlockLevelReader(BlockState state, Block blk, @Nullable LevelReader reader) {
        super(state, blk, (BlockGetter)reader);
        this.reader = reader;
    }

    public SingleBlockLevelReader(BlockState state, @Nullable LevelReader reader) {
        super(state, state.getBlock(), (BlockGetter)reader);
        this.reader = reader;
    }

    public SingleBlockLevelReader(BlockState state, Block blk, BlockPos pos, @Nullable LevelReader reader) {
        super(state, blk, pos, (BlockGetter)reader);
        this.reader = reader;
    }

    public SingleBlockLevelReader(BlockState state, BlockPos pos, @Nullable LevelReader reader) {
        super(state, pos, (BlockGetter)reader);
        this.reader = reader;
    }

    @Nullable
    public ChunkAccess getChunk(int x, int z, @NotNull ChunkStatus requiredStatus, boolean nonnull) {
        if (this.reader == null) {
            return null;
        }
        return this.reader.getChunk(x, z, requiredStatus, nonnull);
    }

    public boolean hasChunk(int chunkX, int chunkZ) {
        return this.reader != null && this.reader.hasChunk(chunkX, chunkZ);
    }

    public int getHeight(@NotNull Heightmap.Types heightmapType, int x, int z) {
        if (this.reader == null) {
            return 0;
        }
        return this.reader.getHeight(heightmapType, x, z);
    }

    public int getSkyDarken() {
        return 15;
    }

    @NotNull
    public BiomeManager getBiomeManager() {
        if (this.reader == null) {
            throw new IllegalStateException("No reader available.");
        }
        return this.reader.getBiomeManager();
    }

    @NotNull
    public Holder<Biome> getUncachedNoiseBiome(int x, int y, int z) {
        if (this.reader == null) {
            throw new IllegalStateException("No reader available.");
        }
        return this.reader.getUncachedNoiseBiome(x, y, z);
    }

    public boolean isClientSide() {
        return this.reader == null || this.reader.isClientSide();
    }

    public int getSeaLevel() {
        if (this.reader == null) {
            return 63;
        }
        return this.reader.getSeaLevel();
    }

    @NotNull
    public DimensionType dimensionType() {
        if (this.reader == null) {
            throw new IllegalStateException("No reader available.");
        }
        return this.reader.dimensionType();
    }

    @NotNull
    public RegistryAccess registryAccess() {
        if (this.reader == null) {
            return RegistryAccess.EMPTY;
        }
        return this.reader.registryAccess();
    }

    @NotNull
    public FeatureFlagSet enabledFeatures() {
        if (this.reader == null) {
            return FeatureFlagSet.of();
        }
        return this.reader.enabledFeatures();
    }

    public float getShade(@NotNull Direction p_230487_1_, boolean p_230487_2_) {
        if (this.reader == null) {
            return 0.0f;
        }
        return this.reader.getShade(p_230487_1_, p_230487_2_);
    }

    @NotNull
    public LevelLightEngine getLightEngine() {
        if (this.reader == null) {
            throw new IllegalStateException("No reader available.");
        }
        return this.reader.getLightEngine();
    }

    @NotNull
    public WorldBorder getWorldBorder() {
        if (this.reader == null) {
            throw new IllegalStateException("No reader available.");
        }
        return this.reader.getWorldBorder();
    }

    @NotNull
    public List<VoxelShape> getEntityCollisions(@Nullable Entity entity, @NotNull AABB aabb) {
        if (this.reader == null || entity == null) {
            return List.of();
        }
        return this.reader.getEntityCollisions(entity, aabb);
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
        if (pos == this.pos && this.blk instanceof EntityBlock) {
            return ((EntityBlock)this.blk).newBlockEntity(this.pos, this.state);
        }
        if (this.reader == null) {
            return null;
        }
        return this.reader.getBlockEntity(pos);
    }

    @Override
    @NotNull
    public BlockState getBlockState(@NotNull BlockPos pos) {
        if (pos == this.pos) {
            return this.state;
        }
        if (this.reader == null) {
            return Blocks.AIR.defaultBlockState();
        }
        return this.reader.getBlockState(pos);
    }

    @Override
    @NotNull
    public FluidState getFluidState(@NotNull BlockPos pos) {
        return this.getBlockState(pos).getFluidState();
    }
}

