/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.datagen.loot;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.ModBlocks;
import com.ldtteam.domumornamentum.block.decorative.FancyDoorBlock;
import com.ldtteam.domumornamentum.block.decorative.FancyTrapdoorBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.decorative.PostBlock;
import com.ldtteam.domumornamentum.block.vanilla.TrapdoorBlock;
import com.ldtteam.domumornamentum.component.ModDataComponents;
import com.ldtteam.domumornamentum.shingles.ShingleHeightType;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class MaterialLootTableProvider
extends BlockLootSubProvider {
    public MaterialLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        this.dropDoorMateriallyWithProp(ModBlocks.getInstance().getDoor(), (Property<?>)com.ldtteam.domumornamentum.block.vanilla.DoorBlock.TYPE);
        this.dropDoorMateriallyWithProp(ModBlocks.getInstance().getFancyDoor(), (Property<?>)FancyDoorBlock.TYPE);
        this.dropSlabMaterially(ModBlocks.getInstance().getSlab());
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getFence());
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getFenceGate());
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getPaperWall());
        this.dropSelfMaterially(ModBlocks.getInstance().getShingle(ShingleHeightType.DEFAULT));
        this.dropSelfMaterially(ModBlocks.getInstance().getShingle(ShingleHeightType.FLAT_LOWER));
        this.dropSelfMaterially(ModBlocks.getInstance().getShingle(ShingleHeightType.FLAT));
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getShingleSlab());
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getStair());
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getWall());
        this.dropSelfMaterially((Block)ModBlocks.getInstance().getTiledPaperWall());
        this.dropSelfMateriallyWithProp((Block)ModBlocks.getInstance().getFancyTrapdoor(), (Property<?>)FancyTrapdoorBlock.TYPE);
        this.dropSelfMateriallyWithProp((Block)ModBlocks.getInstance().getPanel(), (Property<?>)PanelBlock.TYPE);
        this.dropSelfMateriallyWithProp((Block)ModBlocks.getInstance().getPost(), (Property<?>)PostBlock.TYPE);
        this.dropSelfMateriallyWithProp((Block)ModBlocks.getInstance().getTrapdoor(), (Property<?>)TrapdoorBlock.TYPE);
        ModBlocks.getInstance().getAllBrickBlocks().forEach(this::dropSelfMaterially);
        ModBlocks.getInstance().getAllBrickStairBlocks().forEach(this::dropSelfMaterially);
        ModBlocks.getInstance().getFramedLights().forEach(this::dropSelfMaterially);
        ModBlocks.getInstance().getPillars().forEach(this::dropSelfMaterially);
        ModBlocks.getInstance().getTimberFrames().forEach(this::dropSelfMaterially);
        this.dropSelfMaterially(ModBlocks.getInstance().getDynamicTimberFrame());
    }

    protected Iterable<Block> getKnownBlocks() {
        return BuiltInRegistries.BLOCK.stream().filter(IMateriallyTexturedBlock.class::isInstance).toList();
    }

    protected void dropSelfMaterially(Block block, UnaryOperator<LootPoolSingletonContainer.Builder<?>> itemPoolBuilder) {
        this.add(block, LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)itemPoolBuilder.apply(LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)ModDataComponents.TEXTURE_DATA.get()))))));
    }

    protected void dropSelfMaterially(Block block) {
        this.dropSelfMaterially(block, UnaryOperator.identity());
    }

    protected void dropSelfMateriallyWithProp(Block block, Property<?> property) {
        this.dropSelfMaterially(block, item -> item.apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy(property)));
    }

    protected void dropDoorMateriallyWithProp(DoorBlock block, Property<?> property) {
        this.dropSelfMaterially((Block)block, item -> (LootPoolSingletonContainer.Builder)item.apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy(property)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)com.ldtteam.domumornamentum.block.vanilla.DoorBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))));
    }

    protected void dropSlabMaterially(SlabBlock block) {
        this.dropSelfMaterially((Block)block, item -> item.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)2.0f)).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)block).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)SlabBlock.TYPE, (Comparable)SlabType.DOUBLE)))));
    }
}

