/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block.decorative;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.ldtteam.domumornamentum.block.AbstractBlock;
import com.ldtteam.domumornamentum.block.ICachedItemGroupBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.ldtteam.domumornamentum.block.components.SimpleRetexturableComponent;
import com.ldtteam.domumornamentum.entity.block.DynamicTimberFrameBlockEntity;
import com.ldtteam.domumornamentum.recipe.architectscutter.ArchitectsCutterRecipeBuilder;
import com.ldtteam.domumornamentum.tag.ModTags;
import com.ldtteam.domumornamentum.util.BlockUtils;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicTimberFrameBlock
extends AbstractBlock<DynamicTimberFrameBlock>
implements IMateriallyTexturedBlock,
ICachedItemGroupBlock,
EntityBlock {
    public static final List<IMateriallyTexturedBlockComponent> COMPONENTS = ImmutableList.builder().add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/oak_planks"), ModTags.TIMBERFRAMES_FRAME, Blocks.OAK_PLANKS)).add((Object)new SimpleRetexturableComponent(ResourceLocation.withDefaultNamespace((String)"block/dark_oak_planks"), ModTags.TIMBERFRAMES_CENTER, Blocks.DARK_OAK_PLANKS)).build();
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private final List<ItemStack> fillItemGroupCache = Lists.newArrayList();

    public DynamicTimberFrameBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).pushReaction(PushReaction.PUSH_ONLY).strength(3.0f, 1.0f).noOcclusion());
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter level, BlockPos pos, FluidState fluidState) {
        return true;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
    }

    @NotNull
    public List<IMateriallyTexturedBlockComponent> getComponents() {
        return COMPONENTS;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity timberFrameBlockEntity = (DynamicTimberFrameBlockEntity)tileEntity;
            timberFrameBlockEntity.applyComponentsFromItemStack(stack);
            timberFrameBlockEntity.refreshTextureCache();
            for (Offset offset : Offset.values()) {
                DynamicTimberFrameBlock.updateNeighbor(timberFrameBlockEntity, worldIn.getBlockEntity(offset.applyToBlockPos(pos)), offset, true);
            }
        }
    }

    private static void updateNeighbor(DynamicTimberFrameBlockEntity thisEntity, BlockEntity neighborEntity, Offset offset, boolean added) {
        if (neighborEntity != null && neighborEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity timberFrameBlockEntity = (DynamicTimberFrameBlockEntity)neighborEntity;
            timberFrameBlockEntity.onNeighborUpdate(thisEntity, offset.inverted(), added);
            if (thisEntity != null && timberFrameBlockEntity.getFrameBlock() == thisEntity.getFrameBlock() && timberFrameBlockEntity.getCenterBlock() == thisEntity.getCenterBlock()) {
                thisEntity.onNeighborUpdate(thisEntity, offset, added);
            }
        }
    }

    public BlockState updateShape(BlockState stateIn, @NotNull Direction direction, @NotNull BlockState directionState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos directionPos) {
        BlockEntity tileEntity = worldIn.getBlockEntity(currentPos);
        if (tileEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity timberFrameBlockEntity = (DynamicTimberFrameBlockEntity)tileEntity;
            for (Offset offset : Offset.values()) {
                DynamicTimberFrameBlock.updateNeighbor(timberFrameBlockEntity, worldIn.getBlockEntity(offset.applyToBlockPos(currentPos)), offset, true);
            }
        }
        return stateIn;
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState otherState, boolean drop) {
        super.onRemove(state, worldIn, pos, otherState, drop);
        for (Offset offset : Offset.values()) {
            DynamicTimberFrameBlock.updateNeighbor(null, worldIn.getBlockEntity(offset.applyToBlockPos(pos)), offset, false);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new DynamicTimberFrameBlockEntity(blockPos, blockState);
    }

    @Override
    public void resetCache() {
        this.fillItemGroupCache.clear();
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader world, BlockPos pos, Player player) {
        return BlockUtils.getMaterializedItemStack(world.getBlockEntity(pos), (HolderLookup.Provider)world.registryAccess(), new Property[0]);
    }

    @Override
    public void buildRecipes(RecipeOutput recipeOutput) {
        new ArchitectsCutterRecipeBuilder(this, RecipeCategory.BUILDING_BLOCKS).count(COMPONENTS.size()).save(recipeOutput);
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return this.getDOExplosionResistance((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getExplosionResistance(x$0, x$1, x$2, x$3)), state, level, pos, explosion);
    }

    public float getDestroyProgress(@NotNull BlockState state, @NotNull Player player, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getDODestroyProgress((x$0, x$1, x$2, x$3) -> Float.valueOf(super.getDestroyProgress(x$0, x$1, x$2, x$3)), state, player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        return this.getDOSoundType((x$0, x$1, x$2, x$3) -> super.getSoundType(x$0, x$1, x$2, x$3), state, level, pos, entity);
    }

    @Override
    public IMateriallyTexturedBlockComponent getMainComponent() {
        return COMPONENTS.get(1);
    }

    @Override
    public void fillItemCategory(@NotNull NonNullList<ItemStack> items) {
        this.fillDOItemCategory(this, items, this.fillItemGroupCache);
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DynamicTimberFrameBlockEntity) {
            DynamicTimberFrameBlockEntity dynamicTimberFrameBlockEntity = (DynamicTimberFrameBlockEntity)blockEntity;
            dynamicTimberFrameBlockEntity.rotate(direction.ordinal());
        }
        return super.rotate(state, level, pos, direction);
    }

    public BlockState rotate(BlockState p_60530_, Rotation p_60531_) {
        return super.rotate(p_60530_, p_60531_);
    }

    public static enum Offset {
        UP(BlockPos::above),
        DOWN(BlockPos::below),
        NORTH(BlockPos::north),
        EAST(BlockPos::east),
        SOUTH(BlockPos::south),
        WEST(BlockPos::west),
        UP_EAST(p -> p.above().east()),
        UP_WEST(p -> p.above().west()),
        UP_NORTH(p -> p.above().north()),
        UP_SOUTH(p -> p.above().south()),
        DOWN_EAST(p -> p.below().east()),
        DOWN_WEST(p -> p.below().west()),
        DOWN_NORTH(p -> p.below().north()),
        DOWN_SOUTH(p -> p.below().south());

        private final Function<BlockPos, BlockPos> posTranslationFunction;

        private Offset(Function<BlockPos, BlockPos> changeFunction) {
            this.posTranslationFunction = changeFunction;
        }

        public Offset inverted() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> DOWN;
                case 1 -> UP;
                case 2 -> SOUTH;
                case 4 -> NORTH;
                case 3 -> WEST;
                case 5 -> EAST;
                case 8 -> DOWN_SOUTH;
                case 6 -> DOWN_WEST;
                case 9 -> DOWN_NORTH;
                case 7 -> DOWN_EAST;
                case 13 -> UP_NORTH;
                case 11 -> UP_EAST;
                case 12 -> UP_SOUTH;
                case 10 -> UP_WEST;
            };
        }

        public BlockPos applyToBlockPos(BlockPos pos) {
            return this.posTranslationFunction.apply(pos);
        }

        public Offset rotate() {
            return switch (this.ordinal()) {
                case 2 -> EAST;
                case 4 -> WEST;
                case 3 -> SOUTH;
                case 5 -> NORTH;
                case 8 -> UP_EAST;
                case 6 -> UP_SOUTH;
                case 9 -> UP_WEST;
                case 7 -> UP_NORTH;
                case 13 -> DOWN_WEST;
                case 11 -> DOWN_NORTH;
                case 12 -> DOWN_EAST;
                case 10 -> DOWN_SOUTH;
                default -> this;
            };
        }
    }
}

