/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.press;

import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.press.MechanicalPressBlock;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import io.github.cotrin8672.cem.client.visual.EnchantedShaftVisual;
import io.github.cotrin8672.cem.content.block.press.EnchantableMechanicalPressBlockEntity;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0014J\u0018\u0010\u0018\u001a\u00020\u00102\u000e\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001b0\u001aH\u0016R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/cotrin8672/cem/content/block/press/EnchantablePressVisual;", "Lio/github/cotrin8672/cem/client/visual/EnchantedShaftVisual;", "Lio/github/cotrin8672/cem/content/block/press/EnchantableMechanicalPressBlockEntity;", "Ldev/engine_room/flywheel/lib/visual/SimpleDynamicVisual;", "context", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "blockEntity", "partialTick", "", "<init>", "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lio/github/cotrin8672/cem/content/block/press/EnchantableMechanicalPressBlockEntity;F)V", "pressHead", "Ldev/engine_room/flywheel/lib/instance/OrientedInstance;", "kotlin.jvm.PlatformType", "enchantedPressHead", "beginFrame", "", "ctx", "Ldev/engine_room/flywheel/api/visual/DynamicVisual$Context;", "transformModels", "pt", "getRenderedHeadOffset", "updateLight", "_delete", "collectCrumblingInstances", "consumer", "Ljava/util/function/Consumer;", "Ldev/engine_room/flywheel/api/instance/Instance;", "createenchantablemachinery"})
public final class EnchantablePressVisual
extends EnchantedShaftVisual<EnchantableMechanicalPressBlockEntity>
implements SimpleDynamicVisual {
    private final OrientedInstance pressHead;
    private final OrientedInstance enchantedPressHead;

    public EnchantablePressVisual(@NotNull VisualizationContext context, @NotNull EnchantableMechanicalPressBlockEntity blockEntity, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.pressHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)AllPartialModels.MECHANICAL_PRESS_HEAD)).createInstance();
        this.enchantedPressHead = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, (Model)new BakedModelBuilder(AllPartialModels.MECHANICAL_PRESS_HEAD.get()).materialFunc(EnchantablePressVisual::enchantedPressHead$lambda$0).build()).createInstance();
        Quaternionf q = Axis.YP.rotationDegrees(AngleHelper.horizontalAngle((Direction)((Direction)this.blockState.getValue(MechanicalPressBlock.HORIZONTAL_FACING))));
        this.pressHead.rotation((Quaternionfc)q);
        this.enchantedPressHead.rotation((Quaternionfc)q);
        this.transformModels(partialTick);
    }

    public void beginFrame(@NotNull DynamicVisual.Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        this.transformModels(ctx.partialTick());
    }

    private final void transformModels(float pt) {
        float renderedHeadOffset = this.getRenderedHeadOffset(pt);
        this.pressHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
        this.enchantedPressHead.position((Vec3i)this.getVisualPosition()).translatePosition(0.0f, -renderedHeadOffset, 0.0f).setChanged();
    }

    private final float getRenderedHeadOffset(float pt) {
        BlockEntity blockEntity = this.blockEntity;
        Intrinsics.checkNotNull((Object)blockEntity);
        PressingBehaviour pressingBehaviour = ((EnchantableMechanicalPressBlockEntity)blockEntity).getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(pt) * pressingBehaviour.mode.headOffset;
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        FlatLit[] flatLitArray = new FlatLit[]{this.pressHead};
        this.relight(flatLitArray);
        flatLitArray = new FlatLit[]{this.enchantedPressHead};
        this.relight(flatLitArray);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.pressHead.delete();
        this.enchantedPressHead.delete();
    }

    @Override
    public void collectCrumblingInstances(@NotNull Consumer<Instance> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.pressHead);
        consumer.accept((Instance)this.enchantedPressHead);
    }

    private static final Material enchantedPressHead$lambda$0(RenderType renderType, Boolean bl) {
        return Materials.GLINT;
    }
}

