/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base;

import com.drmangotea.tfmg.TFMG;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base.FluidReservoir;
import com.drmangotea.tfmg.content.machinery.oil_processing.pumpjack.base.TestSavedDataManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;

public class TestSavedData
extends SavedData {
    private List<FluidReservoir> list = new ArrayList<FluidReservoir>();

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider provider) {
        TestSavedDataManager manager = TFMG.DEPOSITS;
        compound.putInt("reservoirCount", manager.list.size());
        for (int i = 0; i < manager.list.size(); ++i) {
            FluidReservoir reservoir = manager.list.get(i);
            CompoundTag reservoirNBT = new CompoundTag();
            reservoirNBT.putLong("Id", reservoir.id);
            reservoirNBT.putInt("Reserves", reservoir.oilReserves);
            reservoirNBT.putInt("DepositCount", reservoir.deposits.size());
            for (int j = 0; j < reservoir.deposits.size(); ++j) {
                reservoirNBT.putLong("Deposit" + j, reservoir.deposits.get(j).longValue());
            }
            compound.put("FluidReservoir" + i, (Tag)reservoirNBT);
        }
        return compound;
    }

    public List<FluidReservoir> getLogisticsNetworks() {
        return this.list;
    }

    public static TestSavedData load(CompoundTag compound, HolderLookup.Provider registries) {
        TestSavedData sd = new TestSavedData();
        sd.list = new ArrayList<FluidReservoir>();
        for (int i = 0; i < compound.getInt("reservoirCount"); ++i) {
            CompoundTag reservoirNBT = compound.getCompound("FluidReservoir" + i);
            FluidReservoir reservoir = new FluidReservoir(reservoirNBT.getLong("Id"));
            for (int j = 0; j < compound.getInt("DepositCount"); ++j) {
                reservoir.deposits.add(reservoirNBT.getLong("Deposit" + j));
            }
            reservoir.oilReserves = reservoirNBT.getInt("Reserves");
            sd.list.add(reservoir);
        }
        return sd;
    }

    public static SavedData.Factory<TestSavedData> factory() {
        return new SavedData.Factory(TestSavedData::new, TestSavedData::load);
    }

    public static TestSavedData load(MinecraftServer server) {
        return (TestSavedData)server.overworld().getDataStorage().computeIfAbsent(TestSavedData.factory(), "tfmg_deposits");
    }
}

