/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.machinery.misc.concrete_hose;

import com.drmangotea.tfmg.content.machinery.misc.concrete_hose.ConcreteFillingBehavior;
import com.drmangotea.tfmg.content.machinery.misc.concrete_hose.ConcreteHoseFluidHandler;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.simibubi.create.content.fluids.hosePulley.HosePulleyBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import java.util.List;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ConcreteHoseBlockEntity
extends KineticBlockEntity {
    LerpedFloat offset = LerpedFloat.linear().startWithValue(0.0);
    boolean isMoving = true;
    public SmartFluidTank internalTank = new SmartFluidTank(1500, this::onTankContentsChanged);
    public IFluidHandler capability;
    public ConcreteFillingBehavior filler;
    public ConcreteHoseFluidHandler handler = new ConcreteHoseFluidHandler(this.internalTank, this.filler, () -> this.worldPosition.below((int)Math.ceil(this.offset.getValue())), () -> !this.isMoving);
    public boolean infinite;

    public ConcreteHoseBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.capability = this.handler;
    }

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)TFMGBlockEntities.CONCRETE_HOSE.get(), (be, context) -> {
            if (context == null || HosePulleyBlock.hasPipeTowards((LevelReader)be.level, (BlockPos)be.worldPosition, (BlockState)be.getBlockState(), (Direction)context)) {
                return be.handler;
            }
            return null;
        });
    }

    public void sendData() {
        this.infinite = this.filler.isInfinite();
        super.sendData();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addToGoggleTooltip = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.infinite) {
            TooltipHelper.addHint(tooltip, (String)"hint.hose_pulley", (Object[])new Object[0]);
        }
        return addToGoggleTooltip;
    }

    public float getInterpolatedOffset(float pt) {
        return this.offset.getValue(pt);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.filler = new ConcreteFillingBehavior((SmartBlockEntity)this);
        behaviours.add(this.filler);
        super.addBehaviours(behaviours);
    }

    protected void onTankContentsChanged(FluidStack contents) {
    }

    public void onSpeedChanged(float previousSpeed) {
        this.isMoving = true;
        if (this.getSpeed() == 0.0f) {
            this.offset.forceNextSync();
            this.offset.setValue((double)Math.round(this.offset.getValue()));
            this.isMoving = false;
        }
        if (this.isMoving) {
            float newOffset = this.offset.getValue() + this.getMovementSpeed();
            if (newOffset < 0.0f) {
                this.isMoving = false;
            }
            if (!this.level.getBlockState(this.worldPosition.below((int)Math.ceil(newOffset))).canBeReplaced()) {
                this.isMoving = false;
            }
            if (this.isMoving) {
                this.filler.reset();
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().expandTowards(0.0, (double)(-this.offset.getValue()), 0.0);
    }

    public void tick() {
        super.tick();
        float newOffset = this.offset.getValue() + this.getMovementSpeed();
        if (newOffset < 0.0f) {
            newOffset = 0.0f;
            this.isMoving = false;
        }
        if (!this.level.getBlockState(this.worldPosition.below((int)Math.ceil(newOffset))).canBeReplaced()) {
            newOffset = (int)newOffset;
            this.isMoving = false;
        }
        if (this.getSpeed() == 0.0f) {
            this.isMoving = false;
        }
        this.offset.setValue((double)newOffset);
        this.invalidateRenderBoundingBox();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.level.isClientSide) {
            return;
        }
        if (this.isMoving) {
            return;
        }
        int ceil = (int)Math.ceil(this.offset.getValue() + this.getMovementSpeed());
        if (this.getMovementSpeed() > 0.0f && this.level.getBlockState(this.worldPosition.below(ceil)).canBeReplaced()) {
            this.isMoving = true;
            this.filler.reset();
            return;
        }
        this.sendData();
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        if (clientPacket) {
            this.offset.forceNextSync();
        }
        compound.put("Offset", (Tag)this.offset.writeNBT());
        compound.put("Tank", (Tag)this.internalTank.writeToNBT(registries, new CompoundTag()));
        super.write(compound, registries, clientPacket);
        if (clientPacket) {
            compound.putBoolean("Infinite", this.infinite);
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        this.offset.readNBT(compound.getCompound("Offset"), clientPacket);
        this.internalTank.readFromNBT(registries, compound.getCompound("Tank"));
        super.read(compound, registries, clientPacket);
        if (clientPacket) {
            this.infinite = compound.getBoolean("Infinite");
        }
    }

    public void invalidate() {
        super.invalidate();
        this.invalidateCapabilities();
    }

    public float getMovementSpeed() {
        float movementSpeed = ConcreteHoseBlockEntity.convertToLinear((float)this.getSpeed());
        if (this.level.isClientSide) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }
}

