/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.transformer.large;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.base.lang.TFMGLang;
import com.drmangotea.tfmg.base.lang.TFMGTexts;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.KineticElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import com.drmangotea.tfmg.content.electricity.network.large_switch.LargeSwitchBlock;
import com.drmangotea.tfmg.content.electricity.network.transformer.large.LargeTransformerBlock;
import com.drmangotea.tfmg.datagen.recipes.TFMGRecipeProvider;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.data.recipe.CommonMetal;
import java.util.List;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LargeTransformerBlockEntity
extends KineticElectricBlockEntity {
    public boolean updateInFront = false;
    public float turnRatio = 1.0f;
    final boolean isMainPart;
    public TransformerConstructionState constructionState = TransformerConstructionState.NEEDS_STEEL;

    public LargeTransformerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.isMainPart = (Boolean)state.getValue((Property)LargeSwitchBlock.IS_MAIN_PART);
    }

    @Override
    public int getPowerUsage() {
        BlockEntity blockEntity;
        if (super.getPowerUsage() == 0) {
            return 0;
        }
        if (this.isMainPart && (blockEntity = this.level.getBlockEntity(this.getBlockPos().relative((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)))) instanceof LargeTransformerBlockEntity) {
            LargeTransformerBlockEntity be = (LargeTransformerBlockEntity)blockEntity;
            return (int)((float)((int)Math.pow(be.data.getVoltage(), 2.0)) / this.resistance());
        }
        return super.getPowerUsage();
    }

    public ItemInteractionResult addComponent(ItemStack stack, Player player, InteractionHand hand) {
        if (this.constructionState == TransformerConstructionState.NEEDS_STEEL && stack.is(CommonMetal.STEEL.storageBlocks.items())) {
            if (!player.isCreative()) {
                player.getItemInHand(hand).shrink(1);
            }
            TFMGUtils.playSound(this.level, this.getBlockPos(), SoundEvents.NETHERITE_BLOCK_PLACE, SoundSource.BLOCKS);
            this.constructionState = TransformerConstructionState.NEEDS_OIL;
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)));
            if (blockEntity instanceof LargeTransformerBlockEntity) {
                LargeTransformerBlockEntity be = (LargeTransformerBlockEntity)blockEntity;
                this.turnRatio = be.turnRatio;
                be.constructionState = this.constructionState;
            }
            this.level.setBlock(this.getBlockPos().relative((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)), (BlockState)((BlockState)this.getBlockState().setValue((Property)LargeTransformerBlock.UNFINISHED_MODEL, (Comparable)Boolean.valueOf(false))).setValue((Property)LargeTransformerBlock.IS_MAIN_PART, (Comparable)Boolean.valueOf(false)), 3);
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)LargeTransformerBlock.UNFINISHED_MODEL, (Comparable)Boolean.valueOf(false)), 3);
            this.onPlaced();
            return ItemInteractionResult.SUCCESS;
        }
        if (this.constructionState == TransformerConstructionState.NEEDS_OIL && stack.is(TFMGRecipeProvider.F.lubricationOil().getBucket())) {
            if (!player.isCreative()) {
                player.setItemInHand(hand, Items.BUCKET.getDefaultInstance());
            }
            TFMGUtils.playSound(this.level, this.getBlockPos(), SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS);
            this.constructionState = TransformerConstructionState.FINISHED;
            BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)));
            if (blockEntity instanceof LargeTransformerBlockEntity) {
                LargeTransformerBlockEntity be = (LargeTransformerBlockEntity)blockEntity;
                be.constructionState = this.constructionState;
            }
            this.onPlaced();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public int voltageGeneration() {
        LargeTransformerBlockEntity be;
        if (this.isMainPart) {
            return 0;
        }
        int voltageGeneration = 0;
        BlockEntity blockEntity = this.getLevelAccessor().getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()));
        if (blockEntity instanceof LargeTransformerBlockEntity && (be = (LargeTransformerBlockEntity)blockEntity).getData().getId() != this.getData().getId() && be.getData().getVoltage() != 0) {
            voltageGeneration = (int)Math.max((float)voltageGeneration, (float)be.data.getVoltage() * this.turnRatio);
        }
        this.getData().getsOutsidePower = true;
        if (voltageGeneration == 0) {
            this.getData().getsOutsidePower = false;
        }
        return voltageGeneration;
    }

    public IElectric getControlledBlock() {
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof LargeTransformerBlockEntity) {
            LargeTransformerBlockEntity be = (LargeTransformerBlockEntity)blockEntity;
            return be;
        }
        return null;
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        compound.putFloat("Ratio", this.turnRatio);
        compound.putString("State", this.constructionState.toString());
    }

    @Override
    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.turnRatio = compound.getFloat("Ratio");
        this.constructionState = Enum.valueOf(TransformerConstructionState.class, compound.getString("State"));
    }

    @Override
    public float resistance() {
        int count;
        IElectric be;
        if (!this.isMainPart) {
            return 0.0f;
        }
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && (count = this.getBlocksConnectedToNetworkCount(this.getControlledBlock().getData().getId())) != 0) {
            return Math.max(be.getNetworkResistance() * count, 0);
        }
        return 0.0f;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
            this.getOrCreateElectricNetwork().handleInsufficientPower();
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public int powerGeneration() {
        LargeTransformerBlockEntity be;
        if (this.isMainPart) {
            return 0;
        }
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()));
        if (blockEntity instanceof LargeTransformerBlockEntity) {
            LargeTransformerBlockEntity be2 = (LargeTransformerBlockEntity)blockEntity;
            if (be2.data.notEnoughPower) {
                return 0;
            }
        }
        int powerGeneration = 0;
        BlockEntity blockEntity2 = this.getLevelAccessor().getBlockEntity(this.getBlockPos().relative(((Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getOpposite()));
        if (blockEntity2 instanceof LargeTransformerBlockEntity && (be = (LargeTransformerBlockEntity)blockEntity2).getData().getId() != this.getData().getId() && be.getData().getVoltage() != 0) {
            int maxPower = switch (this.constructionState.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 100000;
                case 1 -> 50000;
                case 2 -> 30000;
            };
            powerGeneration = Math.max(powerGeneration, maxPower);
        }
        this.getData().getsOutsidePower = true;
        if (powerGeneration == 0) {
            this.getData().getsOutsidePower = false;
        }
        return powerGeneration;
    }

    public void updateInFront() {
        IElectric be;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.worldPosition), (CustomPacketPayload)new UpdateInFrontPacket(BlockPos.of((long)this.getPos())));
        }
        Direction facing = (Direction)this.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING);
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId()) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
    }

    @Override
    public int getMaxCurrent() {
        return 500;
    }

    @Override
    public int getMaxVoltage() {
        return 100000;
    }

    @Override
    public boolean makeMultimeterTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        String stateKey = switch (this.constructionState.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "multimeter.large_transformer.oil_cooled";
            case 1 -> "multimeter.large_transformer.metal_cooled";
            case 2 -> "multimeter.large_transformer.air_cooled";
        };
        TFMGLang.translate(stateKey, new Object[0]).color(6932933).forGoggles(tooltip);
        TFMGTexts.Multimeter.transformerRatio(this.turnRatio);
        super.makeMultimeterTooltip(tooltip, isPlayerSneaking);
        return true;
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return direction == Direction.UP;
    }

    static enum TransformerConstructionState {
        FINISHED,
        NEEDS_OIL,
        NEEDS_STEEL;

    }
}

