/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.transformer.large;

import com.drmangotea.tfmg.base.TFMGShapes;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.network.large_switch.LargeSwitchBlock;
import com.drmangotea.tfmg.content.electricity.network.transformer.large.LargeTransformerBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlockEntities;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeTransformerBlock
extends HorizontalKineticBlock
implements IBE<LargeTransformerBlockEntity> {
    public static final BooleanProperty IS_MAIN_PART = LargeSwitchBlock.IS_MAIN_PART;
    public static final BooleanProperty UNFINISHED_MODEL = BooleanProperty.create((String)"unfinished_model");

    public LargeTransformerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)UNFINISHED_MODEL, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{IS_MAIN_PART, UNFINISHED_MODEL});
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide) {
            BlockPos blockpos = pos.relative((Direction)state.getValue(HORIZONTAL_FACING));
            level.setBlock(blockpos, (BlockState)state.setValue((Property)IS_MAIN_PART, (Comparable)Boolean.valueOf(false)), 3);
            level.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)level, pos, 3);
        }
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (!((Boolean)state.getValue((Property)IS_MAIN_PART)).booleanValue()) {
            return (Boolean)state.getValue((Property)UNFINISHED_MODEL) != false ? TFMGShapes.LARGE_TRANSFORMER_UNFINISHED.get((Direction)state.getValue(HORIZONTAL_FACING)) : TFMGShapes.LARGE_TRANSFORMER.get(((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite());
        }
        return (Boolean)state.getValue((Property)UNFINISHED_MODEL) != false ? TFMGShapes.LARGE_TRANSFORMER_UNFINISHED.get(((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite()) : TFMGShapes.LARGE_TRANSFORMER.get((Direction)state.getValue(HORIZONTAL_FACING));
    }

    private static Direction getNeighbourDirection(boolean mainPart, Direction direction) {
        return mainPart ? direction : direction.getOpposite();
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        BlockEntity blockEntity;
        BlockPos mainPartPos = pos;
        if (!((Boolean)state.getValue((Property)IS_MAIN_PART)).booleanValue()) {
            mainPartPos = pos.relative(((Direction)state.getValue(HORIZONTAL_FACING)).getOpposite());
        }
        if ((blockEntity = level.getBlockEntity(mainPartPos)) instanceof LargeTransformerBlockEntity) {
            LargeTransformerBlockEntity be = (LargeTransformerBlockEntity)blockEntity;
            return be.addComponent(stack, player, hand);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos;
        BlockPos neighbourPos;
        Level level = context.getLevel();
        if (!level.getBlockState(neighbourPos = (pos = context.getClickedPos()).relative(context.getHorizontalDirection().getOpposite())).is(TFMGBlocks.LARGE_COIL)) {
            return null;
        }
        return super.getStateForPlacement(context);
    }

    protected List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        if (!((Boolean)state.getValue((Property)IS_MAIN_PART)).booleanValue()) {
            return new ArrayList<ItemStack>();
        }
        return super.getDrops(state, params);
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (!(facing != LargeTransformerBlock.getNeighbourDirection((Boolean)state.getValue((Property)IS_MAIN_PART), (Direction)state.getValue(HORIZONTAL_FACING)) || facingState.is((Block)this) && facingState.getValue((Property)IS_MAIN_PART) != state.getValue((Property)IS_MAIN_PART))) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        if (!((Boolean)state.getValue((Property)IS_MAIN_PART)).booleanValue()) {
            return false;
        }
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis() == face.getAxis();
    }

    public void onPlace(BlockState pState, Level level, BlockPos pos, BlockState pOldState, boolean pIsMoving) {
        this.withBlockEntityDo((BlockGetter)level, pos, IElectric::onPlaced);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue(HORIZONTAL_FACING)).getClockWise().getAxis();
    }

    public Class<LargeTransformerBlockEntity> getBlockEntityClass() {
        return LargeTransformerBlockEntity.class;
    }

    public BlockEntityType<? extends LargeTransformerBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFMGBlockEntities.LARGE_TRANSFORMER.get();
    }
}

