/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.transformer.large;

import com.drmangotea.tfmg.base.TFMGUtils;
import com.drmangotea.tfmg.content.electricity.network.transformer.large.LargeTransformerBlock;
import com.drmangotea.tfmg.content.electricity.network.transformer.large.LargeTransformerBlockEntity;
import com.drmangotea.tfmg.registry.TFMGBlocks;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class LargeCoilBlockEntity
extends SmartBlockEntity {
    int turns = 0;

    public LargeCoilBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ItemInteractionResult createTransformer(Player player, Direction lookingDirection) {
        BlockPos otherCoilPos = null;
        ArrayList<Direction> coilDirections = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            BlockPos coilPos;
            if (direction.getAxis().isVertical() || !this.level.getBlockState(coilPos = this.getBlockPos().relative(direction)).is(TFMGBlocks.LARGE_COIL)) continue;
            coilDirections.add(direction);
        }
        if (coilDirections.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        Direction otherCoilDirection = coilDirections.size() == 1 ? (Direction)coilDirections.get(0) : (coilDirections.contains(lookingDirection) ? lookingDirection : (Direction)coilDirections.get(0));
        otherCoilPos = this.getBlockPos().relative(otherCoilDirection);
        BlockEntity blockEntity = this.level.getBlockEntity(otherCoilPos);
        if (blockEntity instanceof LargeCoilBlockEntity) {
            BlockEntity blockEntity2;
            LargeCoilBlockEntity be = (LargeCoilBlockEntity)blockEntity;
            float primaryTurns = this.turns;
            float secondaryTurns = be.turns;
            float turnRatio = secondaryTurns / primaryTurns;
            if (!this.level.isClientSide) {
                this.level.setBlock(otherCoilPos, (BlockState)((BlockState)TFMGBlocks.LARGE_TRANSFORMER.getDefaultState().setValue(LargeTransformerBlock.HORIZONTAL_FACING, (Comparable)otherCoilDirection)).setValue((Property)LargeTransformerBlock.IS_MAIN_PART, (Comparable)Boolean.valueOf(false)), 3);
            }
            if ((blockEntity2 = this.level.getBlockEntity(otherCoilPos)) instanceof LargeTransformerBlockEntity) {
                LargeTransformerBlockEntity transformerBe = (LargeTransformerBlockEntity)blockEntity2;
                transformerBe.turnRatio = turnRatio;
            }
            if (!this.level.isClientSide) {
                this.level.setBlock(this.getBlockPos(), (BlockState)TFMGBlocks.LARGE_TRANSFORMER.getDefaultState().setValue(LargeTransformerBlock.HORIZONTAL_FACING, (Comparable)otherCoilDirection), 3);
            }
            TFMGUtils.playSound(this.level, this.getBlockPos(), SoundEvents.NETHERITE_BLOCK_PLACE, SoundSource.BLOCKS);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void setCapacity(ItemStack stack) {
        if (stack.get(TFMGDataComponents.COIL_TURNS) != null) {
            this.turns = (Integer)stack.getOrDefault(TFMGDataComponents.COIL_TURNS, (Object)0);
        }
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.turns = tag.getInt("Turns");
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putInt("Turns", this.turns);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }
}

