/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.network.large_switch;

import com.drmangotea.tfmg.content.electricity.network.large_switch.LargeSwitchBlock;
import com.drmangotea.tfmg.content.electricity.network.large_switch.LargeSwitchBlockEntity;
import com.drmangotea.tfmg.registry.TFMGPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;

public class LargeSwitchVisual
extends KineticBlockEntityVisual<LargeSwitchBlockEntity> {
    protected final RotatingInstance shaft;

    public LargeSwitchVisual(VisualizationContext context, LargeSwitchBlockEntity blockEntity, float partialTick) {
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        Direction facing = ((Direction)blockEntity.getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getCounterClockWise();
        if (!((Boolean)blockEntity.getBlockState().getValue((Property)LargeSwitchBlock.IS_MAIN_PART)).booleanValue()) {
            this.shaft = null;
            return;
        }
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)TFMGPartialModels.LARGE_SWITCH_SHAFT)).createInstance();
        this.shaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, facing).setChanged();
    }

    public void update(float pt) {
        this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    public void updateLight(float partialTick) {
        Direction facing = ((Direction)((LargeSwitchBlockEntity)this.blockEntity).getBlockState().getValue(HorizontalKineticBlock.HORIZONTAL_FACING)).getCounterClockWise();
        BlockPos behind = this.pos.relative(facing);
        this.relight(behind, new FlatLit[]{this.shaft});
    }

    protected void _delete() {
        this.shaft.delete();
    }

    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept((Instance)this.shaft);
    }
}

