/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.configuration_wrench;

import com.drmangotea.tfmg.content.electricity.configuration_wrench.ElectriciansWrenchPacket;
import com.drmangotea.tfmg.registry.TFMGDataComponents;
import com.drmangotea.tfmg.registry.TFMGGuiTextures;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import net.createmod.catnip.gui.AbstractSimiScreen;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.createmod.catnip.gui.element.ScreenElement;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public class ElectriciansWrenchScreen
extends AbstractSimiScreen {
    ItemStack wrench;
    protected InteractionHand hand;
    private IconButton addButton;
    private IconButton subtractButton;
    private IconButton confirmButton;
    int group;

    public ElectriciansWrenchScreen(ItemStack wrench, InteractionHand hand) {
        this.wrench = wrench;
        this.hand = hand;
        if (wrench.get(TFMGDataComponents.CONFIGURATION_WRENCH_NUMBER) != null) {
            this.group = (Integer)wrench.get(TFMGDataComponents.CONFIGURATION_WRENCH_NUMBER);
        }
    }

    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        int value = this.group;
        String valueString = String.valueOf(value);
        this.background().render(graphics, x, y);
        graphics.drawString(this.font, valueString, x + 90 - 3 * valueString.length(), y + 39, 0xFFFFFF, false);
        graphics.drawString(this.font, "Select Group Id", x + 51, y + 4, 0xFFFFFF, false);
        GuiGameElement.of((ItemStack)this.wrench).scale(4.0).rotate(0.0, 0.0, 0.0).at((float)(x + 180), (float)(y + 50)).render(graphics);
    }

    public void init() {
        this.setWindowSize(this.background().width, this.background().height);
        this.setWindowOffset(-20, 0);
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.confirmButton = new IconButton(x + this.background().width - 33, y + this.background().height - 24, (ScreenElement)AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addButton = new IconButton(x + this.background().width - 84, y + this.background().height - 67, (ScreenElement)AllIcons.I_MTD_RIGHT);
        this.addButton.withCallback(this::addNumber);
        this.subtractButton = new IconButton(x + this.background().width - 130, y + this.background().height - 67, (ScreenElement)AllIcons.I_MTD_LEFT);
        this.subtractButton.withCallback(this::substractNumber);
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.addRenderableWidget((GuiEventListener)this.subtractButton);
    }

    public void addNumber() {
        ++this.group;
    }

    public void onClose() {
        super.onClose();
        this.wrench.set(TFMGDataComponents.CONFIGURATION_WRENCH_NUMBER, (Object)this.group);
        ElectriciansWrenchPacket packet = new ElectriciansWrenchPacket(this.group, this.hand);
        packet.applyGroup(this.wrench);
        CatnipServices.NETWORK.sendToServer((CustomPacketPayload)packet);
    }

    public void substractNumber() {
        if (this.group > 0) {
            --this.group;
        }
    }

    public TFMGGuiTextures background() {
        return TFMGGuiTextures.ELECTRICIANS_WRENCH;
    }
}

