/*
 * Decompiled with CFR 0.152.
 */
package com.drmangotea.tfmg.content.electricity.base;

import com.drmangotea.tfmg.base.blocks.TFMGHorizontalDirectionalBlock;
import com.drmangotea.tfmg.content.electricity.base.ElectricBlockEntity;
import com.drmangotea.tfmg.content.electricity.base.IElectric;
import com.drmangotea.tfmg.content.electricity.base.UpdateInFrontPacket;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class VoltageAlteringBlockEntity
extends ElectricBlockEntity {
    public boolean updateInFront = false;

    public VoltageAlteringBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getOutputVoltage() {
        return this.getData().getVoltage();
    }

    public int getOutputPower() {
        return this.getPowerUsage();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.updateInFront) {
            this.updateInFront();
            this.updateInFront = false;
        }
    }

    public int getMaxPowerOutput() {
        return 10000;
    }

    @Override
    public int getMaxCurrent() {
        return 100;
    }

    @Override
    public int getPowerUsage() {
        IElectric be;
        this.getOrCreateElectricNetwork().checkForLoops(this.getBlockPos());
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            return Math.max(be.getNetworkPowerUsage(this), 0);
        }
        return 0;
    }

    public IElectric getControlledBlock() {
        IElectric be;
        Direction facing = this.getBlockState().hasProperty((Property)DirectionalBlock.FACING) ? (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING) : ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId()) {
            return be;
        }
        return null;
    }

    @Override
    public float resistance() {
        int count;
        IElectric be;
        Direction facing = this.getDirection();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite()) && (count = this.getBlocksConnectedToNetworkCount(this.getControlledBlock().getData().getId())) != 0) {
            return Math.max(be.getNetworkResistance() * count, 0);
        }
        return 0.0f;
    }

    public Direction getDirection() {
        if (!this.getBlockState().hasProperty((Property)DirectionalBlock.FACING)) {
            return ((Direction)this.getBlockState().getValue((Property)TFMGHorizontalDirectionalBlock.FACING)).getCounterClockWise();
        }
        return (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING);
    }

    @Override
    public boolean hasElectricitySlot(Direction direction) {
        return this.getDirection().getOpposite() == direction;
    }

    @Override
    public void onNetworkChanged(int oldVoltage, int oldPower) {
        super.onNetworkChanged(oldVoltage, oldPower);
        if (oldVoltage != this.getData().getVoltage() || oldPower != this.getPowerUsage()) {
            this.updateInFront = true;
        }
        this.sendStuff();
        this.setChanged();
    }

    @Override
    public void remove() {
        super.remove();
        this.updateInFront();
    }

    @Override
    public void onPlaced() {
        super.onPlaced();
        this.updateInFront = true;
    }

    public void updateInFrontNextTick() {
        this.updateInFront = true;
    }

    public void updateInFront() {
        IElectric be;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.worldPosition), (CustomPacketPayload)new UpdateInFrontPacket(BlockPos.of((long)this.getPos())));
        }
        Direction facing = this.getBlockState().hasProperty((Property)DirectionalBlock.FACING) ? (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING) : ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.setChanged();
    }

    public void updateBehind() {
        IElectric be;
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            CatnipServices.NETWORK.sendToClientsTrackingChunk(serverLevel, new ChunkPos(this.worldPosition), (CustomPacketPayload)new UpdateInFrontPacket(BlockPos.of((long)this.getPos())));
        }
        Direction facing = this.getBlockState().hasProperty((Property)DirectionalBlock.FACING) ? (Direction)this.getBlockState().getValue((Property)DirectionalBlock.FACING) : ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        facing = facing.getOpposite();
        BlockEntity blockEntity = this.level.getBlockEntity(this.getBlockPos().relative(facing));
        if (blockEntity instanceof IElectric && (be = (IElectric)blockEntity).getData().getId() != this.data.getId() && be.hasElectricitySlot(facing.getOpposite())) {
            be.updateNextTick();
        }
        this.sendStuff();
        this.setChanged();
    }
}

