/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.jmi;

import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.JourneyMapPlugin;
import journeymap.api.v2.client.event.FullscreenMapEvent;
import journeymap.api.v2.client.event.MappingEvent;
import journeymap.api.v2.client.event.RegistryEvent;
import journeymap.api.v2.common.event.ClientEventRegistry;
import journeymap.api.v2.common.event.FullscreenEventRegistry;
import lombok.Generated;
import me.frankv.jmi.JMI;
import me.frankv.jmi.api.ModCompatFactory;
import me.frankv.jmi.api.event.Event;
import me.frankv.jmi.api.event.JMIEventBus;
import me.frankv.jmi.util.OverlayHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
@JourneyMapPlugin(apiVersion="2.0.0")
public class JMIJourneyMapPlugin
implements IClientPlugin {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JMIJourneyMapPlugin.class);
    private IClientAPI jmAPI;
    private ModCompatFactory overlayFactory;

    public void initialize(IClientAPI jmAPI) {
        this.jmAPI = jmAPI;
        this.registerJMEvents();
        this.overlayFactory = new ModCompatFactory(jmAPI, JMI.getClientConfig(), JMI.getJmiEventBus());
        OverlayHelper.setJmAPI(jmAPI);
        JMI.getJmiEventBus().subscribe(Event.JMMappingEvent.class, this::onJMMapping);
        JMI.getJmiEventBus().subscribe(Event.ResetDataEvent.class, e -> jmAPI.removeAll("jmi"));
        log.info("Initialized {}", (Object)this.getClass().getName());
    }

    public String getModId() {
        return "jmi";
    }

    private void registerJMEvents() {
        JMIEventBus eventBus = JMI.getJmiEventBus();
        FullscreenEventRegistry.ADDON_BUTTON_DISPLAY_EVENT.subscribe("jmi", e -> eventBus.sendEvent(new Event.AddButtonDisplay(e.getThemeButtonDisplay())));
        ClientEventRegistry.INFO_SLOT_REGISTRY_EVENT.subscribe("jmi", e -> eventBus.sendEvent(new Event.JMInfoSlotRegistryEvent((RegistryEvent.InfoSlotRegistryEvent)e)));
        ClientEventRegistry.MAPPING_EVENT.subscribe("jmi", e -> eventBus.sendEvent(new Event.JMMappingEvent((MappingEvent)e, JMI.isFirstLogin())));
        FullscreenEventRegistry.FULLSCREEN_MAP_MOVE_EVENT.subscribe("jmi", e -> eventBus.sendEvent(new Event.JMMouseMoveEvent((FullscreenMapEvent.MouseMoveEvent)e)));
        FullscreenEventRegistry.FULLSCREEN_MAP_DRAG_EVENT.subscribe("jmi", e -> eventBus.sendEvent(new Event.JMMouseDraggedEvent((FullscreenMapEvent.MouseDraggedEvent)e)));
        FullscreenEventRegistry.FULLSCREEN_MAP_CLICK_EVENT.subscribe("jmi", e -> eventBus.sendEvent(new Event.JMClickEvent((FullscreenMapEvent.ClickEvent)e)));
    }

    private void onJMMapping(Event.JMMappingEvent event) {
        switch (event.mappingEvent().getStage()) {
            case MAPPING_STARTED: {
                JMI.setFirstLogin(false);
                break;
            }
            case MAPPING_STOPPED: {
                this.jmAPI.removeAll("jmi");
                log.debug("all overlays removed");
            }
        }
    }

    @Generated
    public IClientAPI getJmAPI() {
        return this.jmAPI;
    }

    @Generated
    public ModCompatFactory getOverlayFactory() {
        return this.overlayFactory;
    }
}

