/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.world.entity.projectile;

import forge.com.cursee.more_bows_and_arrows.core.registry.ModEntities;
import forge.com.cursee.more_bows_and_arrows.core.registry.ModItems;
import forge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import forge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.IModArrow;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ModArrow
extends AbstractArrow
implements IModArrow {
    private ArrowType type = ArrowType.NORMAL;

    public ModArrow(EntityType<? extends AbstractArrow> entityType, Level level, ArrowType type) {
        super(entityType, level);
        this.type = type;
    }

    public ModArrow(ArrowType type, LivingEntity livingEntity, Level level, ItemStack weapon) {
        super((EntityType)ModEntities.ENTITY_TYPE_FROM_TYPE_MAP.get((Object)type).get(), livingEntity, level, new ItemStack((ItemLike)ModItems.ARROW_ITEM_FROM_TYPE_MAP.get((Object)type).get()), weapon);
        this.type = type;
        System.out.println("mod arrow created");
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    @Override
    public ArrowType getArrowType() {
        return this.type;
    }

    protected ItemStack getPickupItem() {
        return new ItemStack((ItemLike)ModItems.ARROW_ITEM_FROM_TYPE_MAP.get((Object)this.type).get());
    }

    protected ItemStack getDefaultPickupItem() {
        return new ItemStack((ItemLike)Items.ARROW);
    }

    public void setCustomName(Component name) {
        super.setCustomName(name);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
    }

    protected void onHitBlock(BlockHitResult result) {
        super.onHitBlock(result);
        this.processBlockInteraction(this, result);
    }

    protected void onHitEntity(EntityHitResult result) {
        Entity entity;
        super.onHitEntity(result);
        if (this.type == ArrowType.REALLY_BIG && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.knockback(10.0, -this.getDeltaMovement().x, -this.getDeltaMovement().z);
        }
        this.processEntityInteraction(this, result);
    }
}

