/*
 * Decompiled with CFR 0.152.
 */
package forge.com.cursee.more_bows_and_arrows.core.registry;

import forge.com.cursee.more_bows_and_arrows.MoreBowsAndArrows;
import forge.com.cursee.more_bows_and_arrows.core.util.DeferredRegistryObject;
import forge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.ModArrow;
import forge.com.cursee.more_bows_and_arrows.core.world.entity.projectile.util.ArrowType;
import forge.com.cursee.more_bows_and_arrows.platform.Services;
import java.util.LinkedHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;

public class ModEntities {
    public static final LinkedHashMap<ArrowType, DeferredRegistryObject<EntityType<ModArrow>>> ENTITY_TYPE_FROM_TYPE_MAP = new LinkedHashMap();

    private static boolean forge() {
        return Services.PLATFORM.getEnvironmentName().equalsIgnoreCase("forge");
    }

    public static void loadClass() {
        ModEntities.initializeEntities();
    }

    private static void initializeEntities() {
        for (ArrowType type : ArrowType.values()) {
            float size = 0.5f;
            DeferredRegistryObject<EntityType> arrow = Services.PLATFORM.register(BuiltInRegistries.ENTITY_TYPE, type.name().toLowerCase() + "_arrow", () -> Services.PLATFORM.createEntityType((modArrowEntityType, level) -> new ModArrow((EntityType<? extends AbstractArrow>)modArrowEntityType, (Level)level, type), MobCategory.MISC).sized(size, size).clientTrackingRange(4).updateInterval(20).build(ModEntities.forge() ? null : MoreBowsAndArrows.identifier(type.name().toLowerCase() + "_arrow").toString()));
            ENTITY_TYPE_FROM_TYPE_MAP.put(type, arrow);
        }
    }
}

