/*
 * Decompiled with CFR 0.152.
 */
package common.com.cursee.more_bows_and_arrows.core.world.item.util;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ModParticleFunctions {
    public static void nocturnalBowParticles(Level level, LivingEntity entity) {
        if (level.getGameTime() % 2L != 0L) {
            return;
        }
        Vec3 look = entity.getLookAngle().normalize();
        Vec3 eyePos = entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0);
        Vec3 target = eyePos.add(look.scale(1.5));
        int particleCount = 5;
        double sphereRadius = 1.0;
        double particleSpeed = 0.3;
        for (int i = 0; i < particleCount; ++i) {
            double theta = level.random.nextDouble() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * level.random.nextDouble() - 1.0);
            double x = sphereRadius * Math.sin(phi) * Math.cos(theta);
            double y = sphereRadius * Math.sin(phi) * Math.sin(theta);
            double z = sphereRadius * Math.cos(phi);
            Vec3 offset = new Vec3(x, y, z);
            Vec3 spawnPos = target.add(offset);
            Vec3 motion = target.subtract(spawnPos).normalize().scale(particleSpeed);
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, spawnPos.x, spawnPos.y, spawnPos.z, motion.x, motion.y, motion.z);
        }
    }
}

