/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez;

import com.mojang.serialization.Codec;
import de.maxhenkel.pipez.DirectionalPosition;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.corelib.tag.TagUtils;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class ItemFilter
extends Filter<ItemFilter, Item> {
    private static final Filter.TagConverter<Item> TAG_CONVERTER = (single, location) -> {
        if (single) {
            return new SingleElementTag<Item>(location, (Item)BuiltInRegistries.ITEM.get(location));
        }
        return TagUtils.getItemTag(location);
    };
    public static final Codec<Tag<Item>> TAG_CODEC = ItemFilter.tagCodec(TAG_CONVERTER);
    public static final StreamCodec<RegistryFriendlyByteBuf, Tag<Item>> STREAM_TAG_CODEC = ItemFilter.tagStreamCodec(TAG_CONVERTER);
    public static final Codec<ItemFilter> CODEC = ItemFilter.codec(ItemFilter.class, TAG_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemFilter> STREAM_CODEC = ItemFilter.streamCodec(ItemFilter.class, STREAM_TAG_CODEC);

    public ItemFilter(UUID id, @Nullable Tag<Item> tag, @Nullable CompoundTag metadata, boolean exactMetadata, @Nullable DirectionalPosition destination, boolean invert) {
        super(id, tag, metadata, exactMetadata, destination, invert);
    }

    @Override
    public Codec<ItemFilter> getCodec() {
        return CODEC;
    }

    @Override
    public StreamCodec<RegistryFriendlyByteBuf, ItemFilter> getStreamCodec() {
        return STREAM_CODEC;
    }

    public ItemFilter() {
        this(UUID.randomUUID(), (Tag<Item>)null, (CompoundTag)null, false, (DirectionalPosition)null, false);
    }
}

