/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import com.mojang.datafixers.util.Pair;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreData;
import com.tom.createores.OreDataAttachment;
import com.tom.createores.recipe.VeinRecipe;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;

public class RandomSpreadGenerator {
    private List<RecipeHolder<VeinRecipe>> recipes = new ArrayList<RecipeHolder<VeinRecipe>>();

    public void loadAll(ServerLevel level) {
        this.recipes.addAll(level.getRecipeManager().getAllRecipesFor(CreateOreExcavation.VEIN_RECIPES.getRecipeType()));
        this.recipes.sort(Comparator.comparingInt(RandomSpreadGenerator::getPriority).thenComparing(RecipeHolder::id));
    }

    private static int getPriority(RecipeHolder<VeinRecipe> h) {
        return ((VeinRecipe)h.value()).getNegGenerationPriority();
    }

    public RecipeHolder<VeinRecipe> pick(LevelChunk chunk) {
        int x = chunk.getPos().x;
        int z = chunk.getPos().z;
        int minY = QuartPos.fromBlock((int)chunk.getMinBuildHeight());
        int maxY = minY + QuartPos.fromBlock((int)chunk.getHeight()) - 1;
        ServerLevel level = (ServerLevel)chunk.getLevel();
        for (RecipeHolder<VeinRecipe> recipe : this.recipes) {
            ChunkPos chunkpos = ((VeinRecipe)recipe.value()).getPlacement().getPotentialStructureChunk(level.getSeed(), x, z);
            if (chunkpos.x != x || chunkpos.z != z) continue;
            WorldgenRandom rng = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
            rng.setLargeFeatureSeed(level.getSeed(), x, z);
            Holder biome = chunk.getNoiseBiome(rng.nextInt(4), minY + rng.nextInt(maxY), rng.nextInt(4));
            if (!((VeinRecipe)recipe.value()).canGenerate(level, (Holder<Biome>)biome)) continue;
            return recipe;
        }
        return null;
    }

    private RecipeHolder<VeinRecipe> pick(ServerLevel level, ChunkPos chunk, RecipeHolder<VeinRecipe> last) {
        int minY = QuartPos.fromBlock((int)level.getMinBuildHeight());
        int maxY = minY + QuartPos.fromBlock((int)level.getHeight()) - 1;
        for (RecipeHolder<VeinRecipe> recipe : this.recipes) {
            ChunkPos chunkpos = ((VeinRecipe)recipe.value()).getPlacement().getPotentialStructureChunk(level.getSeed(), chunk.x, chunk.z);
            if (chunkpos.x == chunk.x && chunkpos.z == chunk.z) {
                WorldgenRandom rng = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
                rng.setLargeFeatureSeed(level.getSeed(), chunk.x, chunk.z);
                Holder biome = level.getNoiseBiome(QuartPos.fromSection((int)chunk.x) + rng.nextInt(4), minY + rng.nextInt(maxY), QuartPos.fromSection((int)chunk.z) + rng.nextInt(4));
                if (((VeinRecipe)recipe.value()).canGenerate(level, (Holder<Biome>)biome)) {
                    return recipe;
                }
            }
            if (recipe != last) continue;
            break;
        }
        return null;
    }

    public BlockPos locate(ResourceLocation id, BlockPos pPos, ServerLevel level, int radius) {
        RecipeHolder recipe = level.getRecipeManager().byKey(id).orElse(null);
        if (recipe != null && recipe.value() instanceof VeinRecipe) {
            int i = SectionPos.blockToSectionCoord((int)pPos.getX());
            int j = SectionPos.blockToSectionCoord((int)pPos.getZ());
            for (int k = 0; k <= radius; ++k) {
                OreData data;
                RecipeHolder<VeinRecipe> vr;
                BlockPos pos = this.getNearestGenerated(level, i, j, k, level.getSeed(), (RecipeHolder<VeinRecipe>)recipe);
                if (pos == null || level.isLoaded(pos) && ((vr = (data = OreDataAttachment.getData(level.getChunkAt(pos))).getRecipe(level.getRecipeManager())) == null || !vr.id().equals((Object)id))) continue;
                return pos;
            }
        }
        return null;
    }

    public Pair<BlockPos, RecipeHolder<VeinRecipe>> locate(BlockPos pPos, ServerLevel level, int radius, Predicate<RecipeHolder<VeinRecipe>> filter) {
        int i = SectionPos.blockToSectionCoord((int)pPos.getX());
        int j = SectionPos.blockToSectionCoord((int)pPos.getZ());
        for (int k = 0; k <= radius; ++k) {
            Pair found = null;
            float dist = Float.MAX_VALUE;
            for (int j2 = 0; j2 < this.recipes.size(); ++j2) {
                OreData data;
                float d;
                BlockPos pos;
                RecipeHolder<VeinRecipe> r = this.recipes.get(j2);
                if (!filter.test(r) || (pos = this.getNearestGenerated(level, i, j, k, level.getSeed(), r)) == null || !((d = RandomSpreadGenerator.distance2d(pos, pPos)) < dist) || level.isLoaded(pos) && ((r = (data = OreDataAttachment.getData(level.getChunkAt(pos))).getRecipe(level.getRecipeManager())) == null || !filter.test(r))) continue;
                found = Pair.of((Object)pos, r);
                dist = d;
            }
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private BlockPos getNearestGenerated(ServerLevel pLevel, int pX, int pY, int pZ, long pSeed, RecipeHolder<VeinRecipe> recipe) {
        RandomSpreadStructurePlacement pSpreadPlacement = ((VeinRecipe)recipe.value()).getPlacement();
        int i = pSpreadPlacement.spacing();
        for (int j = -pZ; j <= pZ; ++j) {
            boolean flag = j == -pZ || j == pZ;
            for (int k = -pZ; k <= pZ; ++k) {
                int i1;
                int l;
                ChunkPos chunkpos;
                RecipeHolder<VeinRecipe> picked;
                boolean flag1;
                boolean bl = flag1 = k == -pZ || k == pZ;
                if (!flag && !flag1 || (picked = this.pick(pLevel, chunkpos = pSpreadPlacement.getPotentialStructureChunk(pSeed, l = pX + i * j, i1 = pY + i * k), recipe)) != recipe) continue;
                return chunkpos.getMiddleBlockPosition(0);
            }
        }
        return null;
    }

    public static float distance2d(BlockPos a, BlockPos b) {
        int i = b.getX() - a.getX();
        int j = b.getZ() - a.getZ();
        return Mth.sqrt((float)(i * i + j * j));
    }
}

