/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;

public class NumberFormatter {
    private static final int DIVISION_BASE = 1000;
    private static final char[] ENCODED_POSTFIXES = "KMGTPE".toCharArray();
    public static final Format format;

    public static String formatNumber(long number) {
        String slimResult;
        int width = 4;
        assert (number >= 0L);
        String numberString = Long.toString(number);
        int numberSize = numberString.length();
        if (numberSize <= width) {
            return numberString;
        }
        long base = number;
        double last = base * 1000L;
        int exponent = -1;
        String postFix = "";
        while (numberSize > width) {
            last = base;
            numberSize = Long.toString(base /= 1000L).length() + 1;
            postFix = String.valueOf(ENCODED_POSTFIXES[++exponent]);
        }
        String withPrecision = format.format(last / 1000.0) + postFix;
        String withoutPrecision = Long.toString(base) + postFix;
        String string = slimResult = withPrecision.length() <= width ? withPrecision : withoutPrecision;
        assert (slimResult.length() <= width);
        return slimResult;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format_ = new DecimalFormat(".#;0.#");
        format_.setDecimalFormatSymbols(symbols);
        format_.setRoundingMode(RoundingMode.DOWN);
        format = format_;
    }
}

