/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.Registration;
import com.tom.createores.jei.Vein;
import com.tom.createores.util.NumberFormatter;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.registration.IModIngredientRegistration;
import net.createmod.catnip.gui.element.GuiGameElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class VeinIngredient
implements IIngredientHelper<Vein>,
IIngredientRenderer<Vein> {
    public static final IIngredientType<Vein> VEIN = () -> Vein.class;
    private ItemStack drill;

    public VeinIngredient(IModIngredientRegistration registration) {
        RecipeManager mngr = Minecraft.getInstance().getConnection().getRecipeManager();
        registration.register(VEIN, mngr.getAllRecipesFor(CreateOreExcavation.VEIN_RECIPES.getRecipeType()).stream().map(Vein::new).toList(), (IIngredientHelper)this, (IIngredientRenderer)this, Vein.CODEC);
        this.drill = new ItemStack((ItemLike)Registration.NORMAL_DRILL_ITEM.get());
    }

    public void render(GuiGraphics guiGraphics, Vein ingredient) {
        RenderSystem.enableDepthTest();
        guiGraphics.pose().pushPose();
        GuiGameElement.of((ItemStack)ingredient.recipe0().icon).render(guiGraphics);
        guiGraphics.pose().pushPose();
        float s = 0.5f;
        guiGraphics.pose().translate(8.0f, 8.0f, 100.0f);
        guiGraphics.pose().scale(s, s, s);
        GuiGameElement.of((ItemStack)this.drill).render(guiGraphics);
        guiGraphics.pose().popPose();
        guiGraphics.pose().popPose();
    }

    @Deprecated
    public List<Component> getTooltip(Vein ingredient, TooltipFlag tooltipFlag) {
        return Collections.emptyList();
    }

    public void getTooltip(ITooltipBuilder tooltip, Vein ingredient, TooltipFlag tooltipFlag) {
        tooltip.add((FormattedText)ingredient.recipe0().veinName);
        if (ingredient.recipe0().isInfiniteClient()) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.coe.infiniteVeins"));
        } else {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.coe.finiteVeins", (Object[])new Object[]{NumberFormatter.formatNumber(ingredient.recipe0().getMinAmountClient()), NumberFormatter.formatNumber(ingredient.recipe0().getMaxAmountClient())}));
        }
    }

    public IIngredientType<Vein> getIngredientType() {
        return VEIN;
    }

    public String getDisplayName(Vein ingredient) {
        return ingredient.recipe0().veinName.getString();
    }

    public String getUid(Vein ingredient, UidContext context) {
        return ingredient.id().toString();
    }

    @Deprecated
    public String getUniqueId(Vein ingredient, UidContext context) {
        return this.getUid(ingredient, context);
    }

    public ResourceLocation getResourceLocation(Vein ingredient) {
        return ingredient.id();
    }

    public Vein copyIngredient(Vein ingredient) {
        return ingredient;
    }

    public String getErrorInfo(@Nullable Vein ingredient) {
        return ingredient != null && ingredient.id() != null ? ingredient.id().toString() : "null";
    }
}

