/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.comforts.mixin;

import com.illusivesoulworks.comforts.common.ComfortsEvents;
import com.illusivesoulworks.comforts.common.util.ServerAware;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.SleepStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public class MixinServerSleepStatus {
    @Shadow
    @Final
    private SleepStatus sleepStatus;

    @Inject(at={@At(value="TAIL")}, method={"<init>"})
    private void comforts$onInit(CallbackInfo ci) {
        SleepStatus sleepStatus = this.sleepStatus;
        if (sleepStatus instanceof ServerAware) {
            ServerAware serverAware = (ServerAware)sleepStatus;
            serverAware.comforts$setServer((ServerLevel)this);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"announceSleepStatus"}, cancellable=true)
    private void comforts$onAnnounceSleepStatus(CallbackInfo ci) {
        if (ComfortsEvents.announceSleepStatus(this.sleepStatus, (ServerLevel)this)) {
            ci.cancel();
        }
    }
}

