/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.highlight;

import guideme.internal.shaded.lucene.analysis.TokenFilter;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import java.io.IOException;

final class LimitTokenOffsetFilter
extends TokenFilter {
    private final OffsetAttribute offsetAttrib = this.addAttribute(OffsetAttribute.class);
    private int maxStartOffset;

    LimitTokenOffsetFilter(TokenStream input, int maxStartOffset) {
        super(input);
        if (maxStartOffset < 0) {
            throw new IllegalArgumentException("maxStartOffset must be >= zero");
        }
        this.maxStartOffset = maxStartOffset;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        return this.offsetAttrib.startOffset() <= this.maxStartOffset;
    }
}

