/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import guideme.color.SymbolicColor;
import guideme.document.LytPoint;
import guideme.document.LytRect;
import guideme.document.block.LytParagraph;
import guideme.document.flow.LytFlowSpan;
import guideme.internal.GuideMEClient;
import guideme.internal.screen.GuideScreen;
import guideme.internal.util.Transition;
import guideme.layout.LayoutContext;
import guideme.layout.MinecraftFontMetrics;
import guideme.navigation.NavigationNode;
import guideme.navigation.NavigationTree;
import guideme.render.SimpleRenderContext;
import guideme.ui.GuideUiHost;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class GuideNavBar
extends AbstractWidget {
    public static final int WIDTH_OPEN = 150;
    public static final int WIDTH_CLOSED = 15;
    private static final int CHILD_ROW_INDENT = 10;
    private static final int PARENT_ROW_INDENT = 7;
    private static boolean neverInteracted = true;
    private final Transition widthTransition = new Transition(15.0, 150.0, 0.1, () -> this.width, value -> {
        this.width = (int)Math.round(value);
    });
    private NavigationTree navTree;
    private final List<Row> rows = new ArrayList<Row>();
    private final GuideUiHost screen;
    private int scrollOffset;
    private State state = State.CLOSED;
    private boolean pinned;

    public GuideNavBar(GuideScreen screen) {
        super(0, 0, 15, screen.height, (Component)Component.literal((String)"Navigation Tree"));
        this.screen = screen;
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void onClick(double mouseX, double mouseY, int button) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return;
        }
        Row row = this.pickRow(mouseX, mouseY);
        if (row != null) {
            row.expanded = !row.expanded;
            this.updateLayout();
            SoundManager handler = Minecraft.getInstance().getSoundManager();
            handler.play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)GuideMEClient.GUIDE_CLICK_EVENT, (float)1.0f));
            if (row.node.pageId() != null) {
                this.screen.navigateTo(row.node.pageId());
            }
        }
    }

    public void playDownSound(SoundManager handler) {
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return false;
        }
        this.setScrollOffset((int)Math.round((double)this.scrollOffset - dragY));
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return false;
        }
        this.setScrollOffset((int)Math.round((double)this.scrollOffset - deltaY * 20.0));
        return true;
    }

    private void setScrollOffset(int offset) {
        int maxScrollOffset = 0;
        List<Row> visibleRows = this.rows.stream().filter(Row::isVisible).toList();
        if (!visibleRows.isEmpty()) {
            int contentHeight = visibleRows.getLast().bottom - visibleRows.getFirst().top;
            maxScrollOffset = Math.max(0, contentHeight - this.height);
        }
        this.scrollOffset = Mth.clamp((int)offset, (int)0, (int)maxScrollOffset);
    }

    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        NavigationTree currentNavTree = this.screen.getGuide().getNavigationTree();
        if (currentNavTree != this.navTree) {
            this.recreateRows();
        }
        boolean bl = this.active = !this.rows.isEmpty();
        if (this.rows.isEmpty()) {
            return;
        }
        this.widthTransition.update();
        if (this.state != State.CLOSED) {
            this.updateLayout();
        }
        SimpleRenderContext renderContext = new SimpleRenderContext(graphics);
        double currentTime = GLFW.glfwGetTime();
        boolean containsMouse = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.width && mouseY <= this.getY() + this.height;
        switch (this.state.ordinal()) {
            case 0: {
                if (containsMouse) {
                    this.state = State.OPENING;
                    this.widthTransition.set(150.0);
                    neverInteracted = false;
                    break;
                }
                if (!neverInteracted) break;
                double ot = Math.abs(currentTime % 6.0 / 3.0 - 1.0);
                if (ot >= 0.9) {
                    double t = (ot - 0.9) * 10.0;
                    double f = GuideNavBar.easeOutBounce(t);
                    this.width = (int)Math.round(15.0 + f * 135.0 * 0.075);
                    break;
                }
                this.width = 15;
                break;
            }
            case 1: {
                if (!containsMouse) {
                    this.state = State.CLOSING;
                    this.widthTransition.set(15.0);
                    break;
                }
                if (this.width < 150) break;
                this.width = 150;
                this.state = State.OPEN;
                break;
            }
            case 2: {
                if (containsMouse || this.pinned) break;
                this.state = State.CLOSING;
                this.widthTransition.set(15.0);
                break;
            }
            case 3: {
                if (containsMouse) {
                    this.state = State.OPENING;
                    this.widthTransition.set(150.0);
                    break;
                }
                if (this.width > 15) break;
                this.width = 15;
                this.state = State.CLOSED;
            }
        }
        this.updateMousePos(mouseX, mouseY);
        if (this.state == State.CLOSED) {
            renderContext.fillGradientHorizontal(this.getX(), this.getY(), this.width, this.height, SymbolicColor.NAVBAR_BG_TOP, SymbolicColor.NAVBAR_BG_BOTTOM);
            Vec2 p1 = new Vec2((float)(this.width - 15 + 15 - 4), (float)this.height / 2.0f);
            Vec2 p2 = new Vec2((float)(this.width - 15 + 4), (float)this.height / 2.0f - 5.0f);
            Vec2 p3 = new Vec2((float)(this.width - 15 + 4), (float)this.height / 2.0f + 5.0f);
            renderContext.fillTriangle(p1, p2, p3, SymbolicColor.NAVBAR_EXPAND_ARROW);
        } else if (!this.isPinned()) {
            renderContext.fillGradientVertical(this.getX(), this.getY(), this.width, this.height, SymbolicColor.NAVBAR_BG_TOP, SymbolicColor.NAVBAR_BG_BOTTOM);
        }
        if (this.state != State.CLOSED) {
            graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
            PoseStack pose = graphics.pose();
            pose.pushPose();
            pose.translate((float)this.getX(), (float)(this.getY() - this.scrollOffset), 0.0f);
            LytRect viewport = renderContext.viewport();
            Row hoveredRow = this.pickRow(mouseX, mouseY);
            if (hoveredRow != null) {
                renderContext.fillRect(hoveredRow.getBounds(), SymbolicColor.NAVBAR_ROW_HOVER);
            }
            MultiBufferSource.BufferSource buffers = renderContext.beginBatch();
            for (Row row : this.rows) {
                if (!row.isVisible(viewport)) continue;
                row.paragraph.renderBatch(renderContext, (MultiBufferSource)buffers);
            }
            renderContext.endBatch(buffers);
            for (Row row : this.rows) {
                ItemStack icon;
                if (!row.isVisible(viewport)) continue;
                if (row.hasChildren) {
                    Vec2 p3;
                    Vec2 p2;
                    Vec2 p1;
                    float x = row.getBounds().x();
                    x += 5.0f;
                    float y = row.getBounds().y();
                    y += 2.0f;
                    if (row.expanded) {
                        p1 = new Vec2(x + 5.0f, y);
                        p2 = new Vec2(x, y);
                        p3 = new Vec2(x + 2.5f, y + 5.0f);
                    } else {
                        p1 = new Vec2(x + 5.0f, y + 2.5f);
                        p2 = new Vec2(x, y);
                        p3 = new Vec2(x, y + 5.0f);
                    }
                    SymbolicColor color = row == hoveredRow ? SymbolicColor.LINK : SymbolicColor.BODY_TEXT;
                    renderContext.fillTriangle(p1, p2, p3, color);
                }
                if ((icon = row.node.icon()).isEmpty()) continue;
                renderContext.renderItem(icon, row.paragraph.getBounds().x() - 9, row.paragraph.getBounds().y(), 1, 8.0f, 8.0f);
            }
            pose.popPose();
            graphics.disableScissor();
        }
    }

    public static double easeOutBounce(double x) {
        return Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0));
    }

    @Nullable
    private Row pickRow(double x, double y) {
        LytPoint vpPos = this.getViewportPoint(x, y);
        if (vpPos != null) {
            for (Row row : this.rows) {
                if (!row.isVisible() || !(vpPos.y() >= (float)row.top) || !(vpPos.y() < (float)row.bottom)) continue;
                return row;
            }
        }
        return null;
    }

    private void updateMousePos(double x, double y) {
        LytPoint vpPos = this.getViewportPoint(x, y);
        for (Row row : this.rows) {
            if (!row.isVisible()) continue;
            if (vpPos != null && row.contains(vpPos.x(), vpPos.y())) {
                row.paragraph.onMouseEnter(row.span);
                continue;
            }
            row.paragraph.onMouseLeave();
        }
    }

    private void recreateRows() {
        this.navTree = this.screen.getGuide().getNavigationTree();
        this.rows.clear();
        for (NavigationNode rootNode : this.navTree.getRootNodes()) {
            Row row = new Row(rootNode, null);
            this.rows.add(row);
            for (NavigationNode child : row.node.children()) {
                row.hasChildren = true;
                Row childRow = new Row(child, row);
                this.rows.add(childRow);
            }
        }
        this.updateLayout();
    }

    private void updateLayout() {
        LayoutContext context = new LayoutContext(new MinecraftFontMetrics());
        int currentY = 0;
        for (Row row : this.rows) {
            if (!row.isVisible()) continue;
            int indent = row.hasChildren ? 7 : (row.parent != null ? 10 : 0);
            if (!row.node.icon().isEmpty()) {
                indent += 8;
            }
            int x = indent;
            int width = 150 - indent;
            LytRect bounds = row.paragraph.layout(context, x, currentY, width);
            row.top = bounds.y();
            row.bottom = bounds.bottom();
            currentY = bounds.bottom();
        }
    }

    @Nullable
    private LytPoint getViewportPoint(double screenX, double screenY) {
        if (this.state != State.OPENING && this.state != State.OPEN) {
            return null;
        }
        if (screenX >= (double)this.getX() && screenX < (double)(this.getX() + this.width) && screenY >= (double)this.getY() && screenY < (double)(this.getY() + this.height)) {
            int vpX = (int)Math.round(screenX - (double)this.getX());
            int vpY = (int)Math.round(screenY + (double)this.scrollOffset - (double)this.getY());
            return new LytPoint(vpX, vpY);
        }
        return null;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
        if (pinned) {
            this.state = State.OPEN;
            this.setWidth(150);
            this.widthTransition.set(150.0);
        }
    }

    public boolean isPinned() {
        return this.pinned;
    }

    static enum State {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }

    private class Row {
        private final NavigationNode node;
        private final LytParagraph paragraph = new LytParagraph();
        public final LytFlowSpan span;
        private boolean expanded;
        private final Row parent;
        private boolean hasChildren;
        public int top;
        public int bottom;

        public Row(NavigationNode node, Row parent) {
            this.node = node;
            this.parent = parent;
            this.span = new LytFlowSpan();
            this.span.appendText(node.title());
            this.span.modifyHoverStyle(style -> style.color(SymbolicColor.LINK));
            this.paragraph.setPaddingLeft(5);
            this.paragraph.append(this.span);
        }

        public LytRect getBounds() {
            return new LytRect(0, this.top, GuideNavBar.this.width, this.bottom - this.top);
        }

        public boolean contains(float x, float y) {
            return x >= 0.0f && x < (float)GuideNavBar.this.width && y >= (float)this.top && y < (float)this.bottom;
        }

        public boolean isVisible() {
            return this.parent == null || this.parent.expanded;
        }

        public boolean isVisible(LytRect viewport) {
            return this.isVisible() && this.bottom > viewport.y() && this.top < viewport.bottom();
        }
    }
}

